package ru.yandex.direct.oneshot.oneshots.bsexport.adgroups

import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component
import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.common.db.PpcPropertyNames
import ru.yandex.direct.core.entity.adgroup.repository.AdGroupRepository
import ru.yandex.direct.ess.client.EssClient
import ru.yandex.direct.ess.common.models.BaseLogicObject
import ru.yandex.direct.ess.config.bsexport.adgroup.BsExportAdGroupConfig
import ru.yandex.direct.ess.logicobjects.bsexport.DebugInfo
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.AdGroupResourceType
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.BsExportAdGroupObject
import ru.yandex.direct.oneshot.oneshots.bsexport.BaseResyncOneshot
import ru.yandex.direct.oneshot.worker.def.Approvers
import ru.yandex.direct.oneshot.worker.def.Multilaunch
import ru.yandex.direct.oneshot.worker.def.PausedStatusOnFail
import ru.yandex.direct.oneshot.worker.def.Retries
import ru.yandex.direct.tracing.Trace
import ru.yandex.direct.ytwrapper.client.YtProvider

/**
 * Ваншот для переотправки выбранных групп в `//home/adv/DirectAdGroups` через ESS
 * Читает строки пачками, размер пачки на данный момнт регулируется пропертей RESYNC_AD_GROUPS_CHUNK_SIZE
 * Если пачка для обработки непустая, то после итерации делается пауза, которая регулируется пропертей RESYNC_AD_GROUPS_RELAX_TIME
 * @see BaseResyncOneshot
 */
@Component
@Approvers("mspirit", "zakhar", "pema4", "xy6er")
@Multilaunch
@Retries(5)
@PausedStatusOnFail
class AdGroupsResyncOneshot @Autowired constructor(
    ytProvider: YtProvider,
    essClient: EssClient,
    ppcPropertiesSupport: PpcPropertiesSupport,
    adGroupRepository: AdGroupRepository,
) : BaseAdGroupsResyncOneshot(ytProvider, essClient, adGroupRepository) {

    override val chunkSizeProperty =
        ppcPropertiesSupport.get(PpcPropertyNames.RESYNC_AD_GROUPS_CHUNK_SIZE)

    override val relaxTimeProperty =
        ppcPropertiesSupport.get(PpcPropertyNames.RESYNC_AD_GROUPS_RELAX_TIME)

    override val essLogicProcessName: String =
        BsExportAdGroupConfig().logicProcessName

    override fun createLogicObject(request: AdGroupsForResync, entity: AdGroupIdWithCampaignId): BaseLogicObject {
        val debugInfo = DebugInfo(
            reqid = Trace.current().spanId,
            service = Trace.current().service,
            method = Trace.current().method
        )
        return BsExportAdGroupObject(
            adGroupId = entity.id,
            campaignId = entity.campaignId,
            resourceType = AdGroupResourceType.ALL,
            debugInfo = debugInfo
        )
    }
}
