package ru.yandex.direct.oneshot.oneshots.bsexport.adgroups

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.adgroup.AdGroupShowCondition
import ru.yandex.direct.bstransport.yt.repository.adgroup.AdGroupsPosition
import ru.yandex.direct.bstransport.yt.service.YtHashBorders
import ru.yandex.direct.bstransport.yt.service.adgroups.AdGroupsShowConditionTableToQueueResyncService
import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.common.db.PpcPropertyNames.AD_GROUPS_SHOW_CONDITION_SORTED_TABLE_TO_QUEUE_ONESHOT_CHUNK
import ru.yandex.direct.dbutil.sharding.ShardSupport
import ru.yandex.direct.oneshot.oneshots.bsexport.BaseTableToQueueOneshot
import ru.yandex.direct.oneshot.worker.def.Approvers
import ru.yandex.direct.oneshot.worker.def.Multilaunch
import ru.yandex.direct.oneshot.worker.def.PausedStatusOnFail
import ru.yandex.direct.oneshot.worker.def.Retries

data class ShowConditionTableToQueueState(
    val ytHash: Long = 0L,
    val nextAdGroupId: Long = 0L,
)

/**
 * Ваншот для пререотправки строк таблицы условий показа Единой базы в очередь Caesar
 */
@Component
@Approvers("mspirit", "zakhar", "pema4")
@Multilaunch
@Retries(5)
@PausedStatusOnFail
class AdGroupsShowConditionTableToQueueOneshot(
    tableToQueueResyncService: AdGroupsShowConditionTableToQueueResyncService,
    ppcPropertiesSupport: PpcPropertiesSupport,
    shardSupport: ShardSupport
) : BaseTableToQueueOneshot<AdGroupShowCondition, AdGroupsPosition, ShowConditionTableToQueueState>(tableToQueueResyncService, shardSupport) {

    override val chunkSizeProperty = ppcPropertiesSupport.get(AD_GROUPS_SHOW_CONDITION_SORTED_TABLE_TO_QUEUE_ONESHOT_CHUNK)

    override fun execute(inputData: Unit, prevState: ShowConditionTableToQueueState?, shard: Int): ShowConditionTableToQueueState? {
        val position = prevState?.let { AdGroupsPosition(prevState.ytHash, prevState.nextAdGroupId) }
        val nextPosition = resync(shard, position)
        return nextPosition?.let { ShowConditionTableToQueueState(nextPosition.ytHash, nextPosition.adGroupsId) }
    }

    override fun getPositionFromYtBorders(ytHashBorders: YtHashBorders) = AdGroupsPosition(ytHashBorders.first, 0)
}
