package ru.yandex.direct.oneshot.oneshots.bsexport.adgroups

import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component
import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.common.db.PpcPropertyNames
import ru.yandex.direct.core.entity.adgroup.repository.AdGroupRepository
import ru.yandex.direct.ess.client.EssClient
import ru.yandex.direct.ess.common.models.BaseLogicObject
import ru.yandex.direct.ess.config.bsexport.adgroup.BsExportAdGroupShowConditionConfig
import ru.yandex.direct.ess.logicobjects.bsexport.DebugInfo
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.AdGroupShowConditionType
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.BsExportAdGroupShowConditionObject
import ru.yandex.direct.oneshot.oneshots.bsexport.BaseResyncOneshot
import ru.yandex.direct.oneshot.worker.def.Approvers
import ru.yandex.direct.oneshot.worker.def.Multilaunch
import ru.yandex.direct.oneshot.worker.def.PausedStatusOnFail
import ru.yandex.direct.oneshot.worker.def.Retries
import ru.yandex.direct.tracing.Trace
import ru.yandex.direct.ytwrapper.client.YtProvider

/**
 * Ваншот для переотправки условий показа для выбранных групп в `//home/adv/DirectAdGroupShowConditions` через ESS
 * Читает строки пачками, размер пачки на данный момент регулируется пропертей RESYNC_AD_GROUP_SHOW_CONDITIONS_CHUNK_SIZE
 * Если пачка для обработки непустая, то после итерации делается пауза, которая регулируется пропертей RESYNC_AD_GROUP_SHOW_CONDITIONS_RELAX_TIME
 * @see BaseResyncOneshot
 */
@Component
@Approvers("mspirit", "zakhar", "pema4")
@Multilaunch
@Retries(5)
@PausedStatusOnFail
class AdGroupsShowConditionsResyncOneshot @Autowired constructor(
    ytProvider: YtProvider,
    essClient: EssClient,
    ppcPropertiesSupport: PpcPropertiesSupport,
    adGroupRepository: AdGroupRepository,
) : BaseAdGroupsResyncOneshot(ytProvider, essClient, adGroupRepository) {

    override val chunkSizeProperty =
        ppcPropertiesSupport.get(PpcPropertyNames.RESYNC_AD_GROUP_SHOW_CONDITIONS_CHUNK_SIZE)

    override val relaxTimeProperty =
        ppcPropertiesSupport.get(PpcPropertyNames.RESYNC_AD_GROUP_SHOW_CONDITIONS_RELAX_TIME)

    override val essLogicProcessName: String =
        BsExportAdGroupShowConditionConfig().logicProcessName

    override fun createLogicObject(request: AdGroupsForResync, entity: AdGroupIdWithCampaignId): BaseLogicObject {
        val debugInfo = DebugInfo(
            reqid = Trace.current().spanId,
            service = Trace.current().service,
            method = Trace.current().method
        )
        return BsExportAdGroupShowConditionObject(
            adGroupId = entity.id,
            campaignId = entity.campaignId,
            type = AdGroupShowConditionType.ALL,
            debugInfo = debugInfo
        )
    }
}
