package ru.yandex.direct.oneshot.oneshots.bsexport.adgroups

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.adgroup.AdGroup
import ru.yandex.direct.bstransport.yt.repository.adgroup.AdGroupsPosition
import ru.yandex.direct.bstransport.yt.service.YtHashBorders
import ru.yandex.direct.bstransport.yt.service.adgroups.AdGroupsTableToQueueResyncService
import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.common.db.PpcPropertyNames.AD_GROUPS_SORTED_TABLE_TO_QUEUE_ONESHOT_CHUNK
import ru.yandex.direct.dbutil.sharding.ShardSupport
import ru.yandex.direct.oneshot.oneshots.bsexport.BaseTableToQueueOneshot
import ru.yandex.direct.oneshot.worker.def.Approvers
import ru.yandex.direct.oneshot.worker.def.Multilaunch
import ru.yandex.direct.oneshot.worker.def.PausedStatusOnFail
import ru.yandex.direct.oneshot.worker.def.Retries

data class TableToQueueState(
    val ytHash: Long = 0L,
    val nextAdGroupId: Long = 0L,
)

/**
 * Ваншот для пререотправки строк таблицы групп Единой базы в очередь Caesar
 */
@Component
@Approvers("mspirit", "zakhar", "pema4")
@Multilaunch
@Retries(5)
@PausedStatusOnFail
class AdGroupsTableToQueueOneshot(
    tableToQueueResyncService: AdGroupsTableToQueueResyncService,
    ppcPropertiesSupport: PpcPropertiesSupport,
    shardSupport: ShardSupport
) : BaseTableToQueueOneshot<AdGroup, AdGroupsPosition, TableToQueueState>(tableToQueueResyncService, shardSupport) {

    override val chunkSizeProperty = ppcPropertiesSupport.get(AD_GROUPS_SORTED_TABLE_TO_QUEUE_ONESHOT_CHUNK)

    override fun execute(inputData: Unit, prevState: TableToQueueState?, shard: Int): TableToQueueState? {
        val position = prevState?.let { AdGroupsPosition(prevState.ytHash, prevState.nextAdGroupId) }
        val nextPosition = resync(shard, position)
        return nextPosition?.let { TableToQueueState(nextPosition.ytHash, nextPosition.adGroupsId) }
    }

    override fun getPositionFromYtBorders(ytHashBorders: YtHashBorders) = AdGroupsPosition(ytHashBorders.first, 0)
}
