package ru.yandex.direct.oneshot.oneshots.bsexport.adgroups

import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component
import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.common.db.PpcPropertyNames
import ru.yandex.direct.core.entity.adgroup.repository.AdGroupRepository
import ru.yandex.direct.ess.client.EssClient
import ru.yandex.direct.ess.common.models.BaseLogicObject
import ru.yandex.direct.ess.config.bsexport.adgroup.BsExportAdGroupConfig
import ru.yandex.direct.ess.logicobjects.bsexport.DebugInfo
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.AdGroupResourceType
import ru.yandex.direct.ess.logicobjects.bsexport.adgroup.BsExportAdGroupObject
import ru.yandex.direct.model.ModelWithId
import ru.yandex.direct.oneshot.oneshots.bsexport.BaseResyncOneshot
import ru.yandex.direct.oneshot.oneshots.bsexport.ResyncTableRow
import ru.yandex.direct.oneshot.worker.def.Approvers
import ru.yandex.direct.oneshot.worker.def.Multilaunch
import ru.yandex.direct.oneshot.worker.def.PausedStatusOnFail
import ru.yandex.direct.oneshot.worker.def.Retries
import ru.yandex.direct.tracing.Trace
import ru.yandex.direct.ytwrapper.client.YtProvider
import ru.yandex.direct.ytwrapper.model.YtField

class AdGroupIdWithCampaignId(private val id: Long, val campaignId: Long) : ModelWithId {
    override fun setId(id: Long) {
    }

    override fun getId(): Long {
        return id
    }
}

data class AdGroupsForResync(
    val adGroupId: Long
)

class AdGroupResyncTableRow : ResyncTableRow<AdGroupsForResync>(listOf(PID)) {
    private val pid: Long?
        get() = valueOf(PID)

    companion object {
        private val PID = YtField("pid", Long::class.java)
    }

    override fun convert(): AdGroupsForResync {
        return AdGroupsForResync(pid ?: throw IllegalStateException("ERROR: found null pid"))
    }

    val id: Long
        get() = pid ?: throw IllegalStateException("ERROR: found null pid")
}

abstract class BaseAdGroupsResyncOneshot @Autowired constructor(
    ytProvider: YtProvider,
    essClient: EssClient,
    private val adGroupRepository: AdGroupRepository,
) : BaseResyncOneshot<AdGroupsForResync, AdGroupResyncTableRow>(ytProvider, essClient) {

    override fun createEmptyYtRow(): AdGroupResyncTableRow =
        AdGroupResyncTableRow()

    override fun getLogicObjects(shard: Int, requests: List<AdGroupsForResync>): List<BaseLogicObject> {
        val ids = requests.map { it.adGroupId }.distinct()
        val entities = getEntitiesFromRepository(ids, shard)
            .associateBy { it.id }

        return requests
            .filter { it.adGroupId in entities }
            .map { createLogicObject(it, entities.getValue(it.adGroupId)) }
    }

    private fun getEntitiesFromRepository(ids: Collection<Long>, shard: Int): List<AdGroupIdWithCampaignId> =
        adGroupRepository.getCampaignIdsByAdGroupIds(shard, ids)
            .map { AdGroupIdWithCampaignId(it.key, it.value) }

    abstract fun createLogicObject(request: AdGroupsForResync, entity: AdGroupIdWithCampaignId): BaseLogicObject
}
