package ru.yandex.direct.oneshot.oneshots.bsexport.campaign

import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component
import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.common.db.PpcPropertyNames
import ru.yandex.direct.core.entity.campaign.model.CampaignWithOrderId
import ru.yandex.direct.ess.client.EssClient
import ru.yandex.direct.ess.common.models.BaseLogicObject
import ru.yandex.direct.ess.config.bsexport.campaign.BsExportCampaignConfig
import ru.yandex.direct.ess.logicobjects.bsexport.campaing.BsExportCampaignObject
import ru.yandex.direct.ess.logicobjects.bsexport.campaing.CampaignResourceType
import ru.yandex.direct.logicprocessor.processors.bsexport.utils.SupportedCampaignsService
import ru.yandex.direct.oneshot.oneshots.bsexport.BaseResyncOneshot
import ru.yandex.direct.oneshot.oneshots.bsexport.ResyncTableRow
import ru.yandex.direct.oneshot.worker.def.Approvers
import ru.yandex.direct.oneshot.worker.def.Multilaunch
import ru.yandex.direct.oneshot.worker.def.PausedStatusOnFail
import ru.yandex.direct.oneshot.worker.def.Retries
import ru.yandex.direct.tracing.Trace
import ru.yandex.direct.ytwrapper.client.YtProvider
import ru.yandex.direct.ytwrapper.model.YtField

private typealias Cid = Long

class CampaignResyncTableRow : ResyncTableRow<Cid>(listOf(CID)) {
    private val cid: Long?
        get() = valueOf(CID)

    val id: Long
        get() = cid ?: error("ERROR: found null cid")

    override fun convert(): Cid = cid ?: error("ERROR: found null cid")

    companion object {
        private val CID = YtField("cid", Long::class.java)
    }
}

/**
 * Ваншот для переотправки выбранных кампаний в `//home/adv/DirectCampaigns` через ESS
 * Читает строки пачками, размер пачки на данный момнт регулируется пропертей RESYNC_CAMPAIGNS_CHUNK_SIZE
 * Если пачка для обработки непустая, то после итерации делается пауза, которая регулируется пропертей RESYNC_CAMPAIGNS_RELAX_TIME
 * @see BaseResyncOneshot
 */
@Component
@Approvers("mspirit", "zakhar", "pema4", "xy6er")
@Multilaunch
@Retries(5)
@PausedStatusOnFail
class CampaignsResyncOneshot @Autowired constructor(
    ytProvider: YtProvider,
    essClient: EssClient,
    ppcPropertiesSupport: PpcPropertiesSupport,
    private val supportedCampaignsRepository: SupportedCampaignsService,
) : BaseResyncOneshot<Cid, CampaignResyncTableRow>(ytProvider, essClient) {

    override val chunkSizeProperty =
        ppcPropertiesSupport.get(PpcPropertyNames.RESYNC_CAMPAIGNS_CHUNK_SIZE)

    override val relaxTimeProperty =
        ppcPropertiesSupport.get(PpcPropertyNames.RESYNC_CAMPAIGNS_RELAX_TIME)

    override val essLogicProcessName: String =
        BsExportCampaignConfig().logicProcessName

    override fun createEmptyYtRow(): CampaignResyncTableRow =
        CampaignResyncTableRow()

    override fun getLogicObjects(shard: Int, requests: List<Cid>): List<BaseLogicObject> {
        val ids = requests.distinct()
        val entities = getEntitiesFromRepository(ids, shard)
            .associateBy { it.id }

        return requests
            .filter { it in entities }
            .map { createLogicObject(entities.getValue(it)) }
    }

    private fun getEntitiesFromRepository(ids: Collection<Long>, shard: Int): List<CampaignWithOrderId> =
        supportedCampaignsRepository
            .getCampaignsByIdTyped(shard, ids)
            .map {(_,v) -> v as CampaignWithOrderId }

    private fun createLogicObject(entity: CampaignWithOrderId): BaseLogicObject =
        BsExportCampaignObject.Builder()
            .setCid(entity.id)
            .setCampaignResourceType(CampaignResourceType.ALL)
            .setOrderId(entity.orderId)
            .setMethod(Trace.current().method)
            .setReqid(Trace.current().spanId)
            .setService(Trace.current().service)
            .build()
}
