package ru.yandex.direct.oneshot.oneshots.bsexport.meaningfulgoals

import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component
import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.common.db.PpcPropertyNames
import ru.yandex.direct.core.entity.campaign.model.CampaignWithMeaningfulGoalsWithRequiredFields
import ru.yandex.direct.core.entity.campaign.repository.CampaignTypedRepository
import ru.yandex.direct.ess.client.EssClient
import ru.yandex.direct.ess.common.models.BaseLogicObject
import ru.yandex.direct.ess.config.bsexport.meaningfulgoals.BsExportMeaningfulGoalsConfig
import ru.yandex.direct.ess.logicobjects.bsexport.meaningfulgoals.BsExportMeaningfulGoalsObject
import ru.yandex.direct.oneshot.oneshots.bsexport.BaseResyncOneshot
import ru.yandex.direct.oneshot.oneshots.bsexport.ResyncTableRow
import ru.yandex.direct.oneshot.worker.def.Approvers
import ru.yandex.direct.oneshot.worker.def.Multilaunch
import ru.yandex.direct.oneshot.worker.def.PausedStatusOnFail
import ru.yandex.direct.oneshot.worker.def.Retries
import ru.yandex.direct.ytwrapper.client.YtProvider
import ru.yandex.direct.ytwrapper.model.YtField

class MeaningfulGoalsResyncTableRow : ResyncTableRow<Long>(listOf(CID)) {
    private val cid: Long?
        get() = valueOf(CID)

    companion object {
        private val CID = YtField("cid", Long::class.java)
    }

    override fun convert(): Long {
        return cid ?: throw IllegalStateException("ERROR: found null cid")
    }

    val id: Long
        get() = cid ?: throw IllegalStateException("ERROR: found null cid")
}

/**
 * Ваншот для переотправки выбранных кампаний в `//home/adv/DirectMeaningfulGoals` через ESS
 * Читает строки пачками, размер пачки на данный момнт регулируется пропертей RESYNC_MEANINGFUL_GOALS_CHUNK_SIZE
 * Если пачка для обработки непустая, то после итерации делается пауза, которая регулируется пропертей RESYNC_MEANINGFUL_GOALS_RELAX_TIME
 * @see BaseResyncOneshot
 */
@Component
@Approvers("mspirit", "zakhar", "pema4", "ssdmitriev")
@Multilaunch
@Retries(5)
@PausedStatusOnFail
class MeaningfulGoalsResyncOneshot @Autowired constructor(
        ytProvider: YtProvider,
        essClient: EssClient,
        ppcPropertiesSupport: PpcPropertiesSupport,
        private val campaignTypedRepository: CampaignTypedRepository,
) : BaseResyncOneshot<Long, MeaningfulGoalsResyncTableRow>(ytProvider, essClient) {


    override val chunkSizeProperty =
            ppcPropertiesSupport.get(PpcPropertyNames.RESYNC_MEANINGFUL_GOALS_CHUNK_SIZE)

    override val relaxTimeProperty =
            ppcPropertiesSupport.get(PpcPropertyNames.RESYNC_MEANINGFUL_GOALS_RELAX_TIME)

    override val essLogicProcessName: String =
            BsExportMeaningfulGoalsConfig().logicProcessName

    override fun createEmptyYtRow(): MeaningfulGoalsResyncTableRow =
            MeaningfulGoalsResyncTableRow()

    override fun getLogicObjects(shard: Int, requests: List<Long>): List<BaseLogicObject> {
        val ids = requests.distinct()
        val entities = getEntitiesFromRepository(ids, shard)
                .associateBy { it.id }

        return requests.asSequence()
                .filter { it in entities }
                .map { createLogicObject(it, entities.getValue(it)) }
                .toList()
    }

    private fun getEntitiesFromRepository(ids: Collection<Long>, shard: Int): List<CampaignWithMeaningfulGoalsWithRequiredFields> =
            campaignTypedRepository
                    .getSafely(shard, ids, CampaignWithMeaningfulGoalsWithRequiredFields::class.java)


    private fun createLogicObject(campaignId: Long, entity: CampaignWithMeaningfulGoalsWithRequiredFields): BaseLogicObject =
            BsExportMeaningfulGoalsObject(campaignId, entity.rawMeaningfulGoals)
}

