package ru.yandex.direct.oneshot.oneshots.bsexport.metrikacounters

import org.springframework.stereotype.Component
import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.common.db.PpcProperty
import ru.yandex.direct.common.db.PpcPropertyNames
import ru.yandex.direct.ess.client.EssClient
import ru.yandex.direct.ess.common.models.BaseLogicObject
import ru.yandex.direct.ess.config.bsexport.metrikacounters.BsExportMetrikaCountersConfig
import ru.yandex.direct.ess.logicobjects.bsexport.metrikacounters.BsExportMetrikaCountersObject
import ru.yandex.direct.oneshot.oneshots.bsexport.BaseResyncOneshot
import ru.yandex.direct.oneshot.oneshots.bsexport.ResyncParam
import ru.yandex.direct.oneshot.oneshots.bsexport.ResyncTableRow
import ru.yandex.direct.oneshot.worker.def.Approvers
import ru.yandex.direct.oneshot.worker.def.Multilaunch
import ru.yandex.direct.oneshot.worker.def.PausedStatusOnFail
import ru.yandex.direct.oneshot.worker.def.Retries
import ru.yandex.direct.ytwrapper.client.YtProvider
import ru.yandex.direct.ytwrapper.model.YtField

/**
 * Строка входной таблицы для ваншота. Параметры самого ваншота смотри в [ResyncParam]
 */
class MetrikaCountersResyncTableRow : ResyncTableRow<Long>(listOf(CID)) {
    override fun convert(): Long = valueOf(CID)

    companion object {
        private val CID = YtField("cid", Long::class.java)
    }
}

/**
 * Ваншот лдя переотправки счетчиков метрики выбранных кампаний.
 * Счетчики пишутся через ESS в таблицу `//home/adv/DirectMetrikaCounters`.
 * Размер чанка для переотправки регулируется пропертей [PpcPropertyNames.RESYNC_METRIKA_COUNTERS_CHUNK_SIZE].
 * Время ожидаения между чанками регулируется пропертей [PpcPropertyNames.RESYNC_METRIKA_COUNTERS_RELAX_TIME].
 * @see BaseResyncOneshot
 */
@Component
@Approvers("darkkeks", "mspirit")
@Multilaunch
@Retries(5)
@PausedStatusOnFail
class MetrikaCountersResyncOneshot(
    ytProvider: YtProvider,
    essClient: EssClient,
    ppcPropertiesSupport: PpcPropertiesSupport,
) : BaseResyncOneshot<Long, MetrikaCountersResyncTableRow>(ytProvider, essClient) {

    override val chunkSizeProperty: PpcProperty<Long> =
        ppcPropertiesSupport.get(PpcPropertyNames.RESYNC_METRIKA_COUNTERS_CHUNK_SIZE)

    override val relaxTimeProperty: PpcProperty<Long> =
        ppcPropertiesSupport.get(PpcPropertyNames.RESYNC_METRIKA_COUNTERS_RELAX_TIME)

    override val essLogicProcessName: String =
        BsExportMetrikaCountersConfig.LOGIC_PROCESS_NAME

    override fun createEmptyYtRow(): MetrikaCountersResyncTableRow =
        MetrikaCountersResyncTableRow()

    override fun getLogicObjects(shard: Int, requests: List<Long>): List<BaseLogicObject> =
        requests.map { campaignId -> BsExportMetrikaCountersObject(campaignId = campaignId) }
}
