package ru.yandex.direct.oneshot.oneshots.bsexport.repository

import org.jooq.impl.DSL
import org.springframework.stereotype.Repository
import ru.yandex.direct.dbschema.ppc.Tables.BIDS
import ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS
import ru.yandex.direct.dbutil.wrapper.DslContextProvider
import javax.annotation.ParametersAreNonnullByDefault

@Repository
@ParametersAreNonnullByDefault
open class BsExportCampaignsRepository constructor(
    private val dslContextProvider: DslContextProvider
) {

    fun getMaxCid(shard: Int): Long? =
        dslContextProvider.ppc(shard)
            .select(DSL.max(CAMPAIGNS.CID))
            .from(CAMPAIGNS)
            .fetchOne { it.value1() }


    fun getCids(shard: Int, lastCampaignId: Long, campaignsLimit: Int, keywordsLimit: Int): List<Long> {
        val c = CAMPAIGNS.`as`("c");
        val cids = dslContextProvider.ppc(shard)
            .select(c.CID)
            .from(c)
            .where(
                c.CID.gt(lastCampaignId)
            )
            .orderBy(c.CID)
            .limit(campaignsLimit)
            .fetch(c.CID)
        if (cids.isEmpty()) return cids

        val b = BIDS.`as`("b");
        val maxCid = dslContextProvider.ppc(shard)
            .select(b.CID)
            .from(b)
            .where(b.CID.`in`(cids))
            .orderBy(b.CID)
            .limit(1)
            .offset(keywordsLimit)
            .fetchOne { it.value1() } ?: cids.last()

        return cids.filter { it <= maxCid }
    }
}
