package ru.yandex.direct.oneshot.oneshots.bsexport.resources

import org.springframework.stereotype.Component
import ru.yandex.adv.direct.banner.resources.BannerResources
import ru.yandex.direct.bstransport.yt.repository.resources.ResourcesPosition
import ru.yandex.direct.bstransport.yt.service.YtHashBorders
import ru.yandex.direct.bstransport.yt.service.resources.BannerResourcesTableToQueueResyncService
import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.common.db.PpcPropertyNames.RESOURCES_SORTED_TABLE_TO_QUEUE_ONESHOT_CHUNK
import ru.yandex.direct.dbutil.sharding.ShardSupport
import ru.yandex.direct.oneshot.oneshots.bsexport.BaseTableToQueueOneshot
import ru.yandex.direct.oneshot.worker.def.Approvers
import ru.yandex.direct.oneshot.worker.def.Multilaunch
import ru.yandex.direct.oneshot.worker.def.PausedStatusOnFail
import ru.yandex.direct.oneshot.worker.def.Retries
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

data class TableToQueueState(
    val ytHash: Long = 0L,
    val nextOrderId: Long = 0L,
    val nextBannerId: Long = 0L
)

@Component
@Approvers("mspirit", "zakhar", "pema4")
@Multilaunch
@Retries(5)
@PausedStatusOnFail
class BannerResourcesTableToQueueOneshot(
    tableToQueueResyncService: BannerResourcesTableToQueueResyncService,
    ppcPropertiesSupport: PpcPropertiesSupport,
    shardSupport: ShardSupport
) : BaseTableToQueueOneshot<BannerResources, ResourcesPosition, TableToQueueState>(tableToQueueResyncService, shardSupport) {

    override val chunkSizeProperty = ppcPropertiesSupport.get(RESOURCES_SORTED_TABLE_TO_QUEUE_ONESHOT_CHUNK)
    override fun validate(inputData: Unit): ValidationResult<Unit, Defect<Any>> {
        return ValidationResult.success(inputData)
    }

    override fun execute(inputData: Unit, prevState: TableToQueueState?, shard: Int): TableToQueueState? {
        val position = prevState?.let { ResourcesPosition(prevState.ytHash, prevState.nextOrderId, prevState.nextBannerId) }
        val nextPosition = resync(shard, position)
        return nextPosition?.let { TableToQueueState(nextPosition.ytHash, nextPosition.orderId, nextPosition.bannerId) }
    }

    override fun getPositionFromYtBorders(ytHashBorders: YtHashBorders) = ResourcesPosition(ytHashBorders.first, 0, 0)
}
