package ru.yandex.direct.oneshot.oneshots.change_permalink_to_head.repository

import org.jooq.DSLContext
import org.springframework.stereotype.Repository
import ru.yandex.direct.dbschema.ppc.Tables.BANNERS
import ru.yandex.direct.dbschema.ppc.Tables.BANNER_PERMALINKS
import ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS
import ru.yandex.direct.dbutil.model.ClientId


@Repository
class BannerPermalinksOneshotRepository {

    /**
     * Возвращает коллекцию пар (bannerId, chainId) у клиента [clientId] c пермалинком [permalinkId]
     * у которых bannerId > [fromBannerId].
     * Используется для получения данных порциями, т.к. у одного клиента может быть много записей
     */
    fun getBannerAndChainIdsByPermalinkId(
            dslContext: DSLContext,
            clientId: ClientId,
            permalinkId: Long,
            fromBannerId: Long,
            limit: Int,
    ): List<Pair<Long, Long>> = dslContext
            .select(BANNER_PERMALINKS.BID, BANNER_PERMALINKS.CHAIN_ID)
            .from(BANNER_PERMALINKS)
            .join(BANNERS).on(BANNERS.BID.eq(BANNER_PERMALINKS.BID))
            .join(CAMPAIGNS).on(CAMPAIGNS.CID.eq(BANNERS.CID))
            .where(BANNER_PERMALINKS.PERMALINK.eq(permalinkId))
            .and(CAMPAIGNS.CLIENT_ID.eq(clientId.asLong()))
            .and(BANNER_PERMALINKS.BID.greaterThan(fromBannerId))
            .limit(limit)
            .fetch {
                Pair(it.getValue(BANNER_PERMALINKS.BID),
                        it.getValue(BANNER_PERMALINKS.CHAIN_ID))
            }

    fun changePermalinkByBannerAndPermalinkIds(
            dslContext: DSLContext,
            bannerIds: Collection<Long>,
            permalinkId: Long,
            newPermalinkId: Long,
            newChainId: Long?,
    ): Int = dslContext
            .update(BANNER_PERMALINKS)
            .set(BANNER_PERMALINKS.PERMALINK, newPermalinkId)
            .set(BANNER_PERMALINKS.CHAIN_ID, newChainId ?: 0)
            .where(BANNER_PERMALINKS.BID.`in`(bannerIds)
                    .and(BANNER_PERMALINKS.PERMALINK.eq(permalinkId))
            )
            .execute()
}
