package ru.yandex.direct.oneshot.oneshots.change_permalink_to_head.repository

import org.jooq.DSLContext
import org.springframework.stereotype.Repository
import ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS
import ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGN_PERMALINKS
import ru.yandex.direct.dbutil.model.ClientId


@Repository
class CampaignPermalinksOneshotRepository {

    fun getCampaignIdToChainId(
            dslContext: DSLContext,
            clientId: ClientId,
            permalinkId: Long,
    ): Map<Long, Long> = dslContext
            .select(CAMPAIGN_PERMALINKS.CID, CAMPAIGN_PERMALINKS.CHAIN_ID)
            .from(CAMPAIGN_PERMALINKS)
            .join(CAMPAIGNS).on(CAMPAIGNS.CID.eq(CAMPAIGN_PERMALINKS.CID))
            .where(CAMPAIGN_PERMALINKS.PERMALINK_ID.eq(permalinkId)
                    .and(CAMPAIGNS.CLIENT_ID.eq(clientId.asLong()))
            )
            .fetchMap(CAMPAIGN_PERMALINKS.CID, CAMPAIGN_PERMALINKS.CHAIN_ID)

    fun changePermalinkByCampaignPermalinkIds(
            dslContext: DSLContext,
            campaignIds: Collection<Long>,
            permalinkId: Long,
            newPermalinkId: Long,
            newChainId: Long?,
    ): Int = dslContext
            .update(CAMPAIGN_PERMALINKS)
            .set(CAMPAIGN_PERMALINKS.PERMALINK_ID, newPermalinkId)
            .set(CAMPAIGN_PERMALINKS.CHAIN_ID, newChainId ?: 0)
            .where(CAMPAIGN_PERMALINKS.CID.`in`(campaignIds)
                    .and(CAMPAIGN_PERMALINKS.PERMALINK_ID.eq(permalinkId))
            )
            .execute()
}
