package ru.yandex.direct.oneshot.oneshots.change_permalink_to_head.repository

import org.jooq.DSLContext
import org.springframework.stereotype.Repository
import ru.yandex.direct.dbschema.ppc.Tables.CLIENT_PHONES
import ru.yandex.direct.dbutil.model.ClientId

@Repository
class ClientPhoneOneshotRepository {

    fun changePermalinkByClientPhonePermalinkIds(
            dslContext: DSLContext,
            clientId: ClientId,
            clientPhoneIds: Collection<Long>,
            permalinkId: Long,
            newPermalinkId: Long,
            newCounterId: Long?,
    ): Int = dslContext
            .update(CLIENT_PHONES)
            .set(CLIENT_PHONES.PERMALINK_ID, newPermalinkId)
            .set(CLIENT_PHONES.COUNTER_ID, newCounterId ?: 0)
            .where(CLIENT_PHONES.CLIENT_PHONE_ID.`in`(clientPhoneIds)
                    .and(CLIENT_PHONES.PERMALINK_ID.eq(permalinkId))
                    .and(CLIENT_PHONES.CLIENT_ID.eq(clientId.asLong()))
            )
            .execute()
}
