package ru.yandex.direct.oneshot.oneshots.clean_text_fields_for_image_ad_banners;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.bs.resync.queue.model.BsResyncItem;
import ru.yandex.direct.core.entity.bs.resync.queue.repository.BsResyncQueueRepository;
import ru.yandex.direct.dbschema.ppc.enums.BannersBannerType;
import ru.yandex.direct.dbschema.ppc.tables.Banners;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Repository
@ParametersAreNonnullByDefault
public class AdImageBannerCleanTextFieldsRepository {
    public static final long PRIORITY = 57L;

    private final DslContextProvider dslContextProvider;
    private final BsResyncQueueRepository bsResyncQueueRepository;

    public AdImageBannerCleanTextFieldsRepository(DslContextProvider dslContextProvider,
                                                  BsResyncQueueRepository bsResyncQueueRepository) {
        this.dslContextProvider = dslContextProvider;
        this.bsResyncQueueRepository = bsResyncQueueRepository;
    }

    public List<BannerWithIds> getImageAdBannersWithTextFields(int shard, long minBid, long maxBid) {
        return dslContextProvider.ppc(shard)
                .select(Banners.BANNERS.BID, Banners.BANNERS.PID, Banners.BANNERS.CID)
                .from(Banners.BANNERS)
                .where(BANNERS.BID.between(minBid, maxBid))
                .and(BANNERS.BANNER_TYPE.eq(BannersBannerType.image_ad))
                .and(BANNERS.TITLE.isNotNull()
                        .or(BANNERS.TITLE_EXTENSION.isNotNull())
                        .or(BANNERS.BODY.isNotNull()))
                .fetch(record -> new BannerWithIds(record.get(Banners.BANNERS.CID), record.get(Banners.BANNERS.PID),
                        record.get(Banners.BANNERS.BID)));
    }

    public void cleanTextFieldsAndBsResync(int shard, List<BannerWithIds> banners) {
        List<Long> bids = mapList(banners, BannerWithIds::getBid);

        dslContextProvider.ppcTransaction(shard, conf -> {
            DSLContext dsl = conf.dsl();
            dsl.update(BANNERS)
                    .setNull(BANNERS.TITLE)
                    .setNull(BANNERS.TITLE_EXTENSION)
                    .setNull(BANNERS.BODY)
                    .set(Banners.BANNERS.LAST_CHANGE, Banners.BANNERS.LAST_CHANGE)
                    .where(BANNERS.BID.in(bids))
                    .execute();

            List<BsResyncItem> bsResyncItems
                    = mapList(banners, b -> new BsResyncItem(PRIORITY, b.getCid(), b.getBid(), b.getPid()));
            bsResyncQueueRepository.addToResync(dsl, bsResyncItems);
        });
    }

    public long getMaxBid(int shard) {
        return dslContextProvider.ppc(shard)
                .select(DSL.max(Banners.BANNERS.BID))
                .from(Banners.BANNERS)
                .fetchOne()
                .value1();
    }
}
