package ru.yandex.direct.oneshot.oneshots.cleanup

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.adgroup.repository.AdGroupRepository
import ru.yandex.direct.dbutil.model.ClientId
import ru.yandex.direct.dbutil.sharding.ShardHelper
import ru.yandex.direct.dbutil.sharding.ShardKey
import ru.yandex.direct.dbutil.sharding.ShardSupport
import ru.yandex.direct.dbutil.wrapper.DslContextProvider
import ru.yandex.direct.oneshot.worker.def.Approvers
import ru.yandex.direct.oneshot.worker.def.Multilaunch
import ru.yandex.direct.oneshot.worker.def.Retries

/**
 * Ваншот для удаления групп. Логирует большинство данных перед удалением.
 * Кроме групп обработает данные из bids* таблиц (кроме bids_arc).
 * На вход нужно передать два параметра {"shard": N, "ids":[]}
 */
@Component
@Multilaunch
@Approvers("kuhtich", "bratgrim", "buhter", "poldnev", "ppalex", "gerdler", "ssdmitriev", "xy6er")
@Retries(3)
class DeleteAdGroups(
    shardHelper: ShardHelper,
    private val shardSupport: ShardSupport,
    private val adGroupRepository: AdGroupRepository,
    private val dslContextProvider: DslContextProvider,
) : DeleteAdGroupsDryRun(shardHelper, dslContextProvider) {

    override fun cleanup(shard: Int, ids: List<Long>) {
        logger.info("Going to delete adgroups: {}", ids)
        bidsTables.forEach { (table, field) ->
            logger.info("Deleting data from ${table.name}")
            val cnt = dslContextProvider.ppc(shard)
                .deleteFrom(table)
                .where(field.`in`(ids))
                .execute()
            logger.info("Deleted from ${table.name} $cnt rows")
        }
        logger.info("Deleting adgroups data")
        adGroupRepository.delete(shard, ClientId.fromLong(-1), 0, ids)
        logger.info("Delete adgroups from metabase")
        shardSupport.deleteValues(ShardKey.PID, ids)
    }
}
