package ru.yandex.direct.oneshot.oneshots.cleanup

import org.springframework.stereotype.Component
import ru.yandex.direct.dbschema.ppc.Tables.ADGROUP_BS_TAGS
import ru.yandex.direct.dbschema.ppc.Tables.BIDS_DYNAMIC
import ru.yandex.direct.dbschema.ppc.Tables.BIDS_PERFORMANCE
import ru.yandex.direct.dbschema.ppc.tables.AdgroupAdditionalTargetings.ADGROUP_ADDITIONAL_TARGETINGS
import ru.yandex.direct.dbschema.ppc.tables.AdgroupPageTargets.ADGROUP_PAGE_TARGETS
import ru.yandex.direct.dbschema.ppc.tables.AdgroupPriority.ADGROUP_PRIORITY
import ru.yandex.direct.dbschema.ppc.tables.AdgroupProjectParams.ADGROUP_PROJECT_PARAMS
import ru.yandex.direct.dbschema.ppc.tables.AdgroupPromoactions.ADGROUP_PROMOACTIONS
import ru.yandex.direct.dbschema.ppc.tables.AdgroupsContentPromotion.ADGROUPS_CONTENT_PROMOTION
import ru.yandex.direct.dbschema.ppc.tables.AdgroupsCpmBanner.ADGROUPS_CPM_BANNER
import ru.yandex.direct.dbschema.ppc.tables.AdgroupsCpmVideo.ADGROUPS_CPM_VIDEO
import ru.yandex.direct.dbschema.ppc.tables.AdgroupsDynamic.ADGROUPS_DYNAMIC
import ru.yandex.direct.dbschema.ppc.tables.AdgroupsHypergeoRetargetings.ADGROUPS_HYPERGEO_RETARGETINGS
import ru.yandex.direct.dbschema.ppc.tables.AdgroupsInternal.ADGROUPS_INTERNAL
import ru.yandex.direct.dbschema.ppc.tables.AdgroupsMinusWords.ADGROUPS_MINUS_WORDS
import ru.yandex.direct.dbschema.ppc.tables.AdgroupsMobileContent.ADGROUPS_MOBILE_CONTENT
import ru.yandex.direct.dbschema.ppc.tables.AdgroupsPerformance.ADGROUPS_PERFORMANCE
import ru.yandex.direct.dbschema.ppc.tables.AdgroupsText.ADGROUPS_TEXT
import ru.yandex.direct.dbschema.ppc.tables.Bids.BIDS
import ru.yandex.direct.dbschema.ppc.tables.BidsBase.BIDS_BASE
import ru.yandex.direct.dbschema.ppc.tables.BidsRetargeting.BIDS_RETARGETING
import ru.yandex.direct.dbschema.ppc.tables.GroupParams.GROUP_PARAMS
import ru.yandex.direct.dbschema.ppc.tables.Phrases.PHRASES
import ru.yandex.direct.dbschema.ppc.tables.TagGroup.TAG_GROUP
import ru.yandex.direct.dbschema.ppc.tables.VideoSegmentGoals.VIDEO_SEGMENT_GOALS
import ru.yandex.direct.dbschema.ppcdict.tables.ShardIncPid.SHARD_INC_PID
import ru.yandex.direct.dbutil.sharding.ShardHelper
import ru.yandex.direct.dbutil.wrapper.DslContextProvider
import ru.yandex.direct.oneshot.worker.def.Multilaunch
import ru.yandex.direct.oneshot.worker.def.Retries
import ru.yandex.direct.oneshot.worker.def.SafeOneshot

/**
 * Ваншот для проверки удаления групп. Только логирует данные, не удаляет.
 * На вход нужно принимает два параметра {"shard": N, "ids":[]}
 */
@Component
@Multilaunch
@SafeOneshot
@Retries(3)
open class DeleteAdGroupsDryRun(
    shardHelper: ShardHelper,
    private val dslContextProvider: DslContextProvider,
) : BaseCleanupOneshot(shardHelper) {
    companion object {
        // adGroupRepository.delete
        private val tableByPid = listOf(
            PHRASES,
            ADGROUPS_MOBILE_CONTENT,
            ADGROUPS_DYNAMIC,
            ADGROUPS_CPM_BANNER,
            ADGROUPS_CPM_VIDEO,
            ADGROUPS_PERFORMANCE,
            ADGROUPS_CONTENT_PROMOTION,
            GROUP_PARAMS,
            ADGROUP_BS_TAGS,
            ADGROUPS_MINUS_WORDS,
            VIDEO_SEGMENT_GOALS,
            ADGROUP_PAGE_TARGETS,
            ADGROUP_PRIORITY,
            ADGROUP_PROJECT_PARAMS,
            ADGROUP_PROMOACTIONS,
            ADGROUPS_HYPERGEO_RETARGETINGS,
            ADGROUPS_INTERNAL,
            ADGROUPS_TEXT,
        )
        private val adgroupTablesToField = mapOf(
            TAG_GROUP to TAG_GROUP.PID,
            ADGROUP_ADDITIONAL_TARGETINGS to ADGROUP_ADDITIONAL_TARGETINGS.PID,
        )
        val bidsTables = mapOf(
            BIDS to BIDS.PID,
            BIDS_BASE to BIDS_BASE.PID,
            BIDS_RETARGETING to BIDS_RETARGETING.PID,
            BIDS_PERFORMANCE to BIDS_PERFORMANCE.PID,
            BIDS_DYNAMIC to BIDS_DYNAMIC.PID,
        )
        val tables = tableByPid.associateWith { it.field(0) }
            .plus(adgroupTablesToField)
            .plus(bidsTables)
        // актуальность списка: 2022-07-15
    }

    final override fun logData(shard: Int, ids: List<Long>) {
        val ppcDslContext = dslContextProvider.ppc(shard)
        tables.forEach { (table, pidField) ->
            val fields = table.fields()
            ppcDslContext.select(*fields)
                .from(table)
                .where(pidField.`in`(ids))
                .forEach { RowLogger.log(table, it) }
        }
        dslContextProvider.ppcdict()
            .select(*SHARD_INC_PID.fields())
            .from(SHARD_INC_PID)
            .where(SHARD_INC_PID.PID.`in`(ids))
            .forEach { RowLogger.log(SHARD_INC_PID, it) }
    }

    override fun cleanup(shard: Int, ids: List<Long>) {
        // cleanup метод специально определен (пусть и одинаковым) во всех DryRun ваншотах
        // это нужно, чтобы нельзя было поменять поведение кода без "ревью безопасного ваншота" (в релизе)
        logger.info("this is dryRun: skip cleanup for chunk")
    }
}
