package ru.yandex.direct.oneshot.oneshots.cleanup

import org.springframework.stereotype.Component
import ru.yandex.direct.dbschema.ppc.tables.AggregatorDomains.AGGREGATOR_DOMAINS
import ru.yandex.direct.dbschema.ppc.tables.BannerAdditionalHrefs.BANNER_ADDITIONAL_HREFS
import ru.yandex.direct.dbschema.ppc.tables.BannerButtons.BANNER_BUTTONS
import ru.yandex.direct.dbschema.ppc.tables.BannerDisplayHrefTexts.BANNER_DISPLAY_HREF_TEXTS
import ru.yandex.direct.dbschema.ppc.tables.BannerDisplayHrefs.BANNER_DISPLAY_HREFS
import ru.yandex.direct.dbschema.ppc.tables.BannerImageAsset.BANNER_IMAGE_ASSET
import ru.yandex.direct.dbschema.ppc.tables.BannerImages.BANNER_IMAGES
import ru.yandex.direct.dbschema.ppc.tables.BannerLeadformAttributes.BANNER_LEADFORM_ATTRIBUTES
import ru.yandex.direct.dbschema.ppc.tables.BannerLogos.BANNER_LOGOS
import ru.yandex.direct.dbschema.ppc.tables.BannerMeasurers.BANNER_MEASURERS
import ru.yandex.direct.dbschema.ppc.tables.BannerMulticardSets.BANNER_MULTICARD_SETS
import ru.yandex.direct.dbschema.ppc.tables.BannerMulticards.BANNER_MULTICARDS
import ru.yandex.direct.dbschema.ppc.tables.BannerNames.BANNER_NAMES
import ru.yandex.direct.dbschema.ppc.tables.BannerPermalinks.BANNER_PERMALINKS
import ru.yandex.direct.dbschema.ppc.tables.BannerPhones.BANNER_PHONES
import ru.yandex.direct.dbschema.ppc.tables.BannerPixels.BANNER_PIXELS
import ru.yandex.direct.dbschema.ppc.tables.BannerPrices.BANNER_PRICES
import ru.yandex.direct.dbschema.ppc.tables.BannerTurboApps.BANNER_TURBO_APPS
import ru.yandex.direct.dbschema.ppc.tables.BannerTurboGalleries.BANNER_TURBO_GALLERIES
import ru.yandex.direct.dbschema.ppc.tables.BannerTurbolandingParams.BANNER_TURBOLANDING_PARAMS
import ru.yandex.direct.dbschema.ppc.tables.BannerTurbolandings.BANNER_TURBOLANDINGS
import ru.yandex.direct.dbschema.ppc.tables.BannerUserFlagsUpdates.BANNER_USER_FLAGS_UPDATES
import ru.yandex.direct.dbschema.ppc.tables.Banners.BANNERS
import ru.yandex.direct.dbschema.ppc.tables.BannersAdditions.BANNERS_ADDITIONS
import ru.yandex.direct.dbschema.ppc.tables.BannersContentPromotion.BANNERS_CONTENT_PROMOTION
import ru.yandex.direct.dbschema.ppc.tables.BannersContentPromotionVideo.BANNERS_CONTENT_PROMOTION_VIDEO
import ru.yandex.direct.dbschema.ppc.tables.BannersInternal.BANNERS_INTERNAL
import ru.yandex.direct.dbschema.ppc.tables.BannersMinusGeo.BANNERS_MINUS_GEO
import ru.yandex.direct.dbschema.ppc.tables.BannersMobileContent.BANNERS_MOBILE_CONTENT
import ru.yandex.direct.dbschema.ppc.tables.BannersPerformance.BANNERS_PERFORMANCE
import ru.yandex.direct.dbschema.ppc.tables.BannersPerformanceMain.BANNERS_PERFORMANCE_MAIN
import ru.yandex.direct.dbschema.ppc.tables.BannersTns.BANNERS_TNS
import ru.yandex.direct.dbschema.ppc.tables.CampTurbolandingMetrikaCounters.CAMP_TURBOLANDING_METRIKA_COUNTERS
import ru.yandex.direct.dbschema.ppc.tables.Images.IMAGES
import ru.yandex.direct.dbschema.ppcdict.tables.ShardIncBid.SHARD_INC_BID
import ru.yandex.direct.dbutil.sharding.ShardHelper
import ru.yandex.direct.dbutil.wrapper.DslContextProvider
import ru.yandex.direct.oneshot.worker.def.Multilaunch
import ru.yandex.direct.oneshot.worker.def.Retries
import ru.yandex.direct.oneshot.worker.def.SafeOneshot

/**
 * Ваншот для проверки удаления баннеров. Логирует данные, не удаленяет.
 * На вход принимает два параметра {"shard": N, "ids":[]}
 */
@Component
@Multilaunch
@SafeOneshot
@Retries(3)
open class DeleteBannersDryRun(
    shardHelper: ShardHelper,
    private val dslContextProvider: DslContextProvider,
) : BaseCleanupOneshot(shardHelper) {

    companion object {
        // bannerRepository.common.deleteBanners
        // bannerRepository.additionalHrefs.deleteAdditionalHrefsForBanners
        // bannerRepository.tns.deleteBannerTnsByBannerIds
        // bannerRepository.pixels.deleteBannerPixelsByBannerIds
        // metrikaCampaignRepository.deleteBannerTurbolandingCounters
        // bannerRepository.measures.deleteBannersMeasurers
        // bannerRepository.names.deleteNamesForBanners
        // bannerRepository.logos.delete
        // bannerRepository.buttons.delete
        // bannerRepository.bigKingImage.delete
        // bannerRepository.performanceMain.delete
        private val tableByBid = listOf(
            BANNERS_CONTENT_PROMOTION_VIDEO,
            BANNERS_CONTENT_PROMOTION,
            BANNERS_MOBILE_CONTENT,
            BANNERS,
            BANNERS_MINUS_GEO,
            BANNERS_INTERNAL,
            BANNERS_ADDITIONS,
            BANNER_DISPLAY_HREFS,
            BANNER_DISPLAY_HREF_TEXTS,
            BANNER_TURBOLANDING_PARAMS,
            BANNER_PRICES,
            BANNER_PERMALINKS,
            BANNER_PHONES,
            BANNER_TURBO_GALLERIES,
            AGGREGATOR_DOMAINS,
            BANNER_TURBO_APPS,
            BANNER_LEADFORM_ATTRIBUTES,
            BANNER_USER_FLAGS_UPDATES,
            BANNERS_TNS,
            BANNER_PIXELS,
            BANNER_MEASURERS,
            BANNER_NAMES,
            BANNER_LOGOS,
            BANNER_BUTTONS,
            BANNER_IMAGE_ASSET,
            BANNERS_PERFORMANCE_MAIN,
            BANNER_MULTICARD_SETS,
        )
        private val bannerTablesToField = mapOf(
            BANNERS_PERFORMANCE to BANNERS_PERFORMANCE.BID,
            BANNER_IMAGES to BANNER_IMAGES.BID,
            IMAGES to IMAGES.BID,
            BANNER_TURBOLANDINGS to BANNER_TURBOLANDINGS.BID,
            BANNER_ADDITIONAL_HREFS to BANNER_ADDITIONAL_HREFS.BID,
            CAMP_TURBOLANDING_METRIKA_COUNTERS to CAMP_TURBOLANDING_METRIKA_COUNTERS.BID,
            BANNER_MULTICARDS to BANNER_MULTICARDS.BID,
        )
        val tables = tableByBid.associateWith { it.field(0) }
            .plus(bannerTablesToField)
        // актуальность списка: 2022-07-13
    }

    final override fun logData(shard: Int, ids: List<Long>) {
        val ppcDslContext = dslContextProvider.ppc(shard)
        tables.forEach { (table, bidField) ->
            val fields = table.fields()
            ppcDslContext.select(*fields)
                .from(table)
                .where(bidField.`in`(ids))
                .forEach { RowLogger.log(table, it) }
        }
        dslContextProvider.ppcdict()
            .select(*SHARD_INC_BID.fields())
            .from(SHARD_INC_BID)
            .where(SHARD_INC_BID.BID.`in`(ids))
            .forEach { RowLogger.log(SHARD_INC_BID, it) }
    }

    override fun cleanup(shard: Int, ids: List<Long>) {
        // cleanup метод специально определен (пусть и одинаковым) во всех DryRun ваншотах
        // это нужно, чтобы нельзя было поменять поведение кода без "ревью безопасного ваншота" (в релизе)
        logger.info("this is dryRun: skip cleanup for chunk")
    }
}
