package ru.yandex.direct.oneshot.oneshots.cleanup

import org.springframework.stereotype.Component
import ru.yandex.direct.dbschema.ppc.tables.Banners.BANNERS
import ru.yandex.direct.dbschema.ppc.tables.MediaplanBanners.MEDIAPLAN_BANNERS
import ru.yandex.direct.dbschema.ppc.tables.Vcards.VCARDS
import ru.yandex.direct.dbschema.ppcdict.tables.ShardIncVcardId.SHARD_INC_VCARD_ID
import ru.yandex.direct.dbutil.sharding.ShardHelper
import ru.yandex.direct.dbutil.wrapper.DslContextProvider
import ru.yandex.direct.oneshot.worker.def.Multilaunch
import ru.yandex.direct.oneshot.worker.def.Retries
import ru.yandex.direct.oneshot.worker.def.SafeOneshot

/**
 * Ваншот для проверки удаления визиток. Логирует визитки и использовавшие их баннеры, базу не модифицирует.
 * На вход принимает два параметра {"shard": N, "ids":[]}
 */
@Component
@Multilaunch
@SafeOneshot
@Retries(3)
open class DeleteVcardsDryRun(
    shardHelper: ShardHelper,
    private val dslContextProvider: DslContextProvider,
) : BaseCleanupOneshot(shardHelper) {

    companion object {
        private val tableByVcardId = listOf(
            VCARDS
        )
        private val vcardTablesToField = mapOf(
            MEDIAPLAN_BANNERS to MEDIAPLAN_BANNERS.VCARD_ID,
            BANNERS to BANNERS.VCARD_ID,
        )
        val tables = tableByVcardId.associateWith { it.field(0) }
            .plus(vcardTablesToField)
    }

    final override fun logData(shard: Int, ids: List<Long>) {
        val ppcDslContext = dslContextProvider.ppc(shard)
        tables.forEach { (table, vcardField) ->
            val fields = table.fields()
            ppcDslContext.select(*fields)
                .from(table)
                .where(vcardField.`in`(ids))
                .forEach { RowLogger.log(table, it) }
        }
        dslContextProvider.ppcdict()
            .select(*SHARD_INC_VCARD_ID.fields())
            .from(SHARD_INC_VCARD_ID)
            .where(SHARD_INC_VCARD_ID.VCARD_ID.`in`(ids))
            .forEach { RowLogger.log(SHARD_INC_VCARD_ID, it) }
    }

    override fun cleanup(shard: Int, ids: List<Long>) {
        // cleanup метод специально определен (пусть и одинаковым) во всех DryRun ваншотах
        // это нужно, чтобы нельзя было поменять поведение кода без "ревью безопасного ваншота" (в релизе)
        logger.info("this is dryRun: skip cleanup for chunk")
    }
}
