package ru.yandex.direct.oneshot.oneshots.cleanup

import org.jooq.Named
import org.jooq.Record
import org.slf4j.Logger
import org.slf4j.LoggerFactory
import ru.yandex.direct.utils.JsonUtils
import ru.yandex.direct.utils.JsonUtilsWithMapper

object RowLogger {
    val logger: Logger = LoggerFactory.getLogger(this::class.java)
    val jsonUtils = JsonUtilsWithMapper(
        JsonUtils.getObjectMapper().copy()
            .registerModule(JsonUtils.createLocalDateModule())
            .registerModule(JsonUtils.createLocalDateTimeModule())
            .registerModule(JsonUtils.createBigDecimalModule())
    )

    fun log(table: Named, record: Record) {
        val logRecord = mapOf("table" to table.name, "record" to record.intoMap())
        logger.info(jsonUtils.toJson(logRecord))
    }
}
