package ru.yandex.direct.oneshot.oneshots.cpmbannerfixminprice.repository;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.currency.Currency;
import ru.yandex.direct.dbschema.ppc.enums.BidsBaseBidType;
import ru.yandex.direct.dbschema.ppc.enums.BidsBaseStatusbssynced;
import ru.yandex.direct.dbschema.ppc.enums.BidsStatusbssynced;
import ru.yandex.direct.dbschema.ppc.enums.CampaignsType;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static ru.yandex.direct.core.entity.campaign.repository.CampaignMappings.currencyCodeToDb;
import static ru.yandex.direct.dbschema.ppc.tables.Bids.BIDS;
import static ru.yandex.direct.dbschema.ppc.tables.BidsBase.BIDS_BASE;
import static ru.yandex.direct.dbschema.ppc.tables.BidsManualPrices.BIDS_MANUAL_PRICES;
import static ru.yandex.direct.dbschema.ppc.tables.Campaigns.CAMPAIGNS;
import static ru.yandex.direct.dbutil.SqlUtils.STRAIGHT_JOIN;

@Repository
@ParametersAreNonnullByDefault
public class OneshotBidRepository {

    private final DslContextProvider dslContextProvider;

    @Autowired
    public OneshotBidRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
    }

    public Map<Long, BigDecimal> getBidIdsToPriceForCpmBannerWithTooLowPrice(int shard,
                                                                             Currency currency) {
        return dslContextProvider.ppc(shard)
                .select(BIDS.ID, BIDS.PRICE)
                .hint(STRAIGHT_JOIN)
                .from(CAMPAIGNS)
                .join(BIDS)
                .on(CAMPAIGNS.CID.eq(BIDS.CID))
                .where(CAMPAIGNS.TYPE.eq(CampaignsType.cpm_banner))
                .and(CAMPAIGNS.CURRENCY.eq(currencyCodeToDb(currency.getCode())))
                .and(BIDS.PRICE.greaterThan(BigDecimal.ZERO))
                .and(BIDS.PRICE.lessThan(currency.getMinCpmPrice()))
                .fetchMap(BIDS.ID, BIDS.PRICE);
    }

    public Map<Long, BigDecimal> getBidsManualPriceIdsToPriceForCpmBannerWithTooLowPrice(int shard,
                                                                                         Currency currency) {
        return dslContextProvider.ppc(shard)
                .selectDistinct(BIDS_MANUAL_PRICES.ID, BIDS_MANUAL_PRICES.PRICE)
                .hint(STRAIGHT_JOIN)
                .from(CAMPAIGNS)
                .join(BIDS_MANUAL_PRICES)
                .on(CAMPAIGNS.CID.eq(BIDS_MANUAL_PRICES.CID))
                .where(CAMPAIGNS.TYPE.eq(CampaignsType.cpm_banner))
                .and(CAMPAIGNS.CURRENCY.eq(currencyCodeToDb(currency.getCode())))
                .and(BIDS_MANUAL_PRICES.PRICE.greaterThan(BigDecimal.ZERO))
                .and(BIDS_MANUAL_PRICES.PRICE.lessThan(currency.getMinCpmPrice()))
                .fetchMap(BIDS_MANUAL_PRICES.ID, BIDS_MANUAL_PRICES.PRICE);
    }

    public Map<Long, BigDecimal> getBidBaseIdsToPriceForCpmBannerWithTooLowPrice(int shard,
                                                                                 Currency currency) {
        return dslContextProvider.ppc(shard)
                .selectDistinct(BIDS_BASE.BID_ID, BIDS_BASE.PRICE)
                .hint(STRAIGHT_JOIN)
                .from(CAMPAIGNS)
                .join(BIDS_BASE)
                .on(CAMPAIGNS.CID.eq(BIDS_BASE.CID))
                .where(CAMPAIGNS.TYPE.eq(CampaignsType.cpm_banner))
                .and(CAMPAIGNS.CURRENCY.eq(currencyCodeToDb(currency.getCode())))
                .and(BIDS_BASE.PRICE.greaterThan(BigDecimal.ZERO))
                .and(BIDS_BASE.PRICE.lessThan(currency.getMinCpmPrice()))
                .and(BIDS_BASE.BID_TYPE.ne(BidsBaseBidType.keyword))
                .fetchMap(BIDS_BASE.BID_ID, BIDS_BASE.PRICE);
    }

    public int updatePriceForBidsIfItsLower(int shard,
                                            Collection<Long> bidIds,
                                            BigDecimal price) {
        return dslContextProvider.ppc(shard).update(BIDS)
                .set(BIDS.PRICE, price)
                .set(BIDS.STATUS_BS_SYNCED, BidsStatusbssynced.No)
                .where(BIDS.ID.in(bidIds))
                .and(BIDS.PRICE.greaterThan(BigDecimal.ZERO))
                .and(BIDS.PRICE.lessThan(price))
                .execute();
    }

    public int updatePriceForBidsManualPriceIfItsLower(int shard,
                                                       Collection<Long> bidsManualPriceIds,
                                                       BigDecimal price) {
        return dslContextProvider.ppc(shard).update(BIDS_MANUAL_PRICES)
                .set(BIDS_MANUAL_PRICES.PRICE, price)
                .where(BIDS_MANUAL_PRICES.ID.in(bidsManualPriceIds))
                .and(BIDS_MANUAL_PRICES.PRICE.greaterThan(BigDecimal.ZERO))
                .and(BIDS_MANUAL_PRICES.PRICE.lessThan(price))
                .execute();
    }

    public int updatePriceForBidsBaseIfItsLower(int shard,
                                                Collection<Long> bidsBaseIds,
                                                BigDecimal price) {
        return dslContextProvider.ppc(shard).update(BIDS_BASE)
                .set(BIDS_BASE.PRICE, price)
                .set(BIDS_BASE.STATUS_BS_SYNCED, BidsBaseStatusbssynced.No)
                .where(BIDS_BASE.BID_ID.in(bidsBaseIds))
                .and(BIDS_BASE.PRICE.greaterThan(BigDecimal.ZERO))
                .and(BIDS_BASE.PRICE.lessThan(price))
                .execute();
    }
}
