package ru.yandex.direct.oneshot.oneshots.creativeupdatepresetid.repository;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import com.mongodb.MongoClient;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
@ParametersAreNonnullByDefault
public class MongoVideoAddtionsRepository {

    private static final String CANVAS_DATABASE = "canvas";
    private static final String VIDEO_CREATIVE_MONGO_COLLECTION_NAME = "video_additions";

    private final MongoClient mongoClient;

    @Autowired
    MongoVideoAddtionsRepository(MongoClient mongoClient) {
        this.mongoClient = mongoClient;
    }

    public Long updatePresetId(List<Long> creativeIds, Long presetId) {
        var collection = mongoClient.getDatabase(CANVAS_DATABASE)
                .getCollection(VIDEO_CREATIVE_MONGO_COLLECTION_NAME);
        var filter = new Document("creative_id", new Document("$in", creativeIds));
        var update = new Document("$set", new Document("preset_id", presetId));
        var updateResult = collection.updateMany(filter, update);
        return updateResult.getModifiedCount();
    }
}
