package ru.yandex.direct.oneshot.oneshots.creativeupdatepresetid.repository;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static ru.yandex.direct.dbschema.ppc.Tables.PERF_CREATIVES;

@Repository
@ParametersAreNonnullByDefault
public class PerfCreativesRepository {
    private final DslContextProvider dslContextProvider;

    @Autowired
    PerfCreativesRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
    }

    public int updateLayoutId(int shard, List<Long> creativeIds, Long layoutId) {
        return dslContextProvider.ppc(shard)
                .update(PERF_CREATIVES)
                .set(PERF_CREATIVES.LAYOUT_ID, layoutId)
                .where(PERF_CREATIVES.CREATIVE_ID.in(creativeIds))
                .execute();
    }
}
