package ru.yandex.direct.oneshot.oneshots.delete_keywords_from_bids_base.repository

import org.springframework.stereotype.Repository
import ru.yandex.direct.dbschema.ppc.Tables.BIDS_BASE
import ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS
import ru.yandex.direct.dbschema.ppc.enums.BidsBaseBidType
import ru.yandex.direct.dbutil.wrapper.DslContextProvider

@Repository
class OneshotBidsBaseRepository constructor(
    private val dslContextProvider: DslContextProvider
) {
    /**
     * Получает {@param limit} фраз из таблицы BIDS_BASE, c BID_ID > fromBidId в шарде {@param shard}
     */
    fun getKeywordsByIds(shard: Int, fromBidId: Long, limit: Long): List<Long> {
        return dslContextProvider.ppc(shard)
            .select(BIDS_BASE.BID_ID)
            .from(BIDS_BASE)
            .where(BIDS_BASE.BID_ID.greaterThan(fromBidId))
            .and(BIDS_BASE.BID_TYPE.eq(BidsBaseBidType.keyword))
            .orderBy(BIDS_BASE.BID_ID)
            .limit(limit)
            .fetch(BIDS_BASE.BID_ID)
    }

    /**
     * Удаляет фразы из таблицы BIDS_BASE с BID_ID {@param bidIds} в шарде {@param shard}
     */
    fun deleteKeywordsByIds(shard: Int, bidIds: Collection<Long>) =
        dslContextProvider.ppc(shard)
            .delete(BIDS_BASE)
            .where(BIDS_BASE.BID_ID.`in`(bidIds))
            .and(BIDS_BASE.BID_TYPE.eq(BidsBaseBidType.keyword))
            .execute()

    /**
     * Получает фразы из таблицы BIDS_BASE, c BID_ID > fromBidId в шарде {@param shard} для {@param clientId}
     */
    fun getKeywordsByIdsForClient(shard: Int, clientId: Long, fromBidId: Long, limit: Long): List<Long> {
        return dslContextProvider.ppc(shard)
            .select(BIDS_BASE.BID_ID)
            .from(BIDS_BASE)
            .join(CAMPAIGNS).on(CAMPAIGNS.CID.eq(BIDS_BASE.CID))
            .where(BIDS_BASE.BID_ID.greaterThan(fromBidId))
            .and(BIDS_BASE.BID_TYPE.eq(BidsBaseBidType.keyword))
            .and(CAMPAIGNS.CLIENT_ID.eq(clientId))
            .orderBy(BIDS_BASE.BID_ID)
            .limit(limit)
            .fetch(BIDS_BASE.BID_ID)
    }
}
