package ru.yandex.direct.oneshot.oneshots.feature

import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.feature.container.FeatureTextIdToClientIdState
import ru.yandex.direct.core.entity.feature.model.FeatureState
import ru.yandex.direct.core.entity.feature.service.FeatureManagingService
import ru.yandex.direct.dbutil.model.ClientId
import ru.yandex.direct.oneshot.worker.def.Approvers
import ru.yandex.direct.oneshot.worker.def.Multilaunch
import ru.yandex.direct.oneshot.worker.def.SimpleOneshot
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.ytwrapper.client.YtProvider
import ru.yandex.direct.ytwrapper.model.YtCluster
import ru.yandex.direct.ytwrapper.model.YtField
import ru.yandex.direct.ytwrapper.model.YtTable
import ru.yandex.direct.ytwrapper.model.YtTableRow

data class EnableFeatureInputData(
    val tablePath: String,
    val featureName: String,
    val enable: Boolean?
)

@Component
@Multilaunch
@Approvers("gerdler", "dimitrovsd", "a-dubov", "bratgrim")
class EnableFeatureOneshot @Autowired constructor(
    private val ytProvider: YtProvider,
    private val featureManagingService: FeatureManagingService
) : SimpleOneshot<EnableFeatureInputData, Void> {

    companion object {
        const val CHUNK_SIZE = 1000
    }

    override fun validate(inputData: EnableFeatureInputData): ValidationResult<EnableFeatureInputData, Defect<Any>> =
        ValidationResult.success(inputData)

    override fun execute(inputData: EnableFeatureInputData, prevState: Void?): Void? {
        val clientIds = mutableListOf<Long>()

        ytProvider.getOperator(YtCluster.HAHN)
            .readTable(YtTable(inputData.tablePath), UserYtTableRow(), { clientIds.add(it.clientId!!) })
        val newState = if (inputData.enable != false) FeatureState.ENABLED else FeatureState.DISABLED

        clientIds.chunked(CHUNK_SIZE).forEach {
            val featureToClientIdStates = it.map {
                FeatureTextIdToClientIdState().apply {
                    clientId = ClientId.fromLong(it)
                    textId = inputData.featureName.toLowerCase()
                    state = newState
                }
            }

            featureManagingService.switchFeaturesStateForClientIds(featureToClientIdStates)
        }

        return null
    }
}

class UserYtTableRow : YtTableRow(listOf(CLIENT_ID)) {

    val clientId: Long?
        get() = valueOf(CLIENT_ID)

    companion object {
        private val CLIENT_ID = YtField("ClientID", Long::class.java)
    }
}
