package ru.yandex.direct.oneshot.oneshots.featurestickets;

import java.util.List;
import java.util.Map;

import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.feature.model.Feature;
import ru.yandex.direct.core.entity.feature.repository.FeatureRepository;
import ru.yandex.direct.oneshot.worker.def.Approvers;
import ru.yandex.direct.oneshot.worker.def.Multilaunch;
import ru.yandex.direct.oneshot.worker.def.SimpleOneshot;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

/**
 * Ваншот создает сторожевой тикет в стартреке для каждой из существующих фичей, если тикета еще нет.
 * И заполняет поле ticket_id в таблице features.
 */
@Multilaunch
@Component
@Approvers({"mexicano", "aleran", "ovazhnev"})
public class CreateFeaturesTicketsOneshot implements SimpleOneshot<Void, Void> {

    private final CreateFeaturesTicketsOneshotStartrekService startrekService;
    private final FeatureRepository featureRepository;
    private static final Logger logger = LoggerFactory.getLogger(CreateFeaturesTicketsOneshot.class);

    @Autowired
    public CreateFeaturesTicketsOneshot(CreateFeaturesTicketsOneshotStartrekService startrekService,
                                        FeatureRepository featureRepository) {
        this.startrekService = startrekService;
        this.featureRepository = featureRepository;
    }

    @Nullable
    @Override
    public Void execute(Void inputData, @Nullable Void prevState) {
        List<Feature> features = featureRepository.get();
        Map<String, String> featureIdToNewTicketId = startrekService.createTickets(features);
        logger.info("Feature name to new ticket: {}", featureIdToNewTicketId);

        featureRepository.updateTicketsIds(featureIdToNewTicketId);

        return null;
    }

    @Override
    public ValidationResult<Void, Defect> validate(Void inputData) {
        return ValidationResult.success(inputData);
    }
}
