package ru.yandex.direct.oneshot.oneshots.fill_bids_phraseid_associate.repository

import java.math.BigInteger
import java.time.LocalDateTime
import java.time.format.DateTimeFormatter
import org.springframework.stereotype.Repository
import ru.yandex.direct.common.util.RepositoryUtils
import ru.yandex.direct.dbschema.ppc.Tables.BIDS_PHRASEID_ASSOCIATE
import ru.yandex.direct.dbutil.wrapper.DslContextProvider
import ru.yandex.direct.oneshot.oneshots.fill_bids_phraseid_associate.BidsPhraseIdAssociate
import ru.yandex.direct.ytwrapper.client.YtProvider
import ru.yandex.direct.ytwrapper.model.YtCluster
import ru.yandex.direct.ytwrapper.model.YtField
import ru.yandex.direct.ytwrapper.model.YtTable
import ru.yandex.direct.ytwrapper.model.YtTableRow

class InputTableRow : YtTableRow(listOf(CID, PID, BIDS_ID, PHRASE_ID, LOG_TIME)) {
    companion object {
        val CID = YtField("cid", java.lang.Long::class.java)
        val PID = YtField("pid", java.lang.Long::class.java)
        val BIDS_ID = YtField("bids_id", java.lang.Long::class.java)
        val PHRASE_ID = YtField("PhraseID", String::class.java)
        val LOG_TIME = YtField("log_time", String::class.java)
    }

    val cid: java.lang.Long get() = valueOf(CID)

    val pid: java.lang.Long get() = valueOf(PID)

    val bidsId: java.lang.Long get() = valueOf(BIDS_ID)

    val phraseID: String get() = valueOf(PHRASE_ID)

    val logTime: String get() = valueOf(LOG_TIME)
}

@Repository
class OneshotFillBidsPhraseIdAssociateRepository(
    private val ytProvider: YtProvider,
    private var dslContextProvider: DslContextProvider,
) {
    companion object {
        val LOG_TIME_FORMATTER: DateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")
    }

    /**
     * Получение записей из Yt таблички, по строкам
     *
     * @param ytCluster кластер
     * @param tablePath таблица
     * @param startRow  номер строки, с которой начинам считывать (включительно)
     * @param lastRow   номер строки, на которой заканчиваем считывать (исключая)
     */
    fun getBidsPhraseIdAssociatesFromYtTable(ytCluster: YtCluster,
                                             tablePath: String,
                                             startRow: Long,
                                             lastRow: Long
    ): List<BidsPhraseIdAssociate> {
        val bidsPhraseIdAssociates = mutableListOf<BidsPhraseIdAssociate>()
        ytProvider.getOperator(ytCluster)
            .readTableByRowRange(YtTable(tablePath), {
                val logTime = LocalDateTime.parse(it.logTime, LOG_TIME_FORMATTER)
                bidsPhraseIdAssociates.add(
                    BidsPhraseIdAssociate(it.cid.toLong(), it.pid.toLong(), it.bidsId.toLong(), BigInteger(it.phraseID), logTime)
                )
            }, InputTableRow(), startRow, lastRow)
        return bidsPhraseIdAssociates
    }


    /**
     * Добавление записи в таблицу bids_phraseid_associate
     */
    fun insertBidsPhraseIdAssociates(
        shard: Int,
        bidsPhraseIdAssociates: List<BidsPhraseIdAssociate>,
    ): Int {
        var insertStep = dslContextProvider.ppc(shard)
            .insertInto(BIDS_PHRASEID_ASSOCIATE)
            .columns(
                BIDS_PHRASEID_ASSOCIATE.CID,
                BIDS_PHRASEID_ASSOCIATE.PID,
                BIDS_PHRASEID_ASSOCIATE.BIDS_ID,
                BIDS_PHRASEID_ASSOCIATE.PHRASE_ID,
                BIDS_PHRASEID_ASSOCIATE.LOGTIME,
            )
        bidsPhraseIdAssociates.forEach {
            insertStep = insertStep.values(
                it.campaignId,
                it.adGroupId,
                it.keywordId,
                RepositoryUtils.bigIntegerToULong(it.bsPhraseID),
                it.logTime,
            )
        }
        return insertStep
            .onDuplicateKeyIgnore()
            .execute()
    }
}
