package ru.yandex.direct.oneshot.oneshots.flatcpcstrategyfromyt.repository;

import java.util.List;

import org.jooq.util.mysql.MySQLDSL;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.keyword.model.Keyword;
import ru.yandex.direct.dbschema.ppc.tables.records.BidsArcRecord;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;

import static ru.yandex.direct.core.entity.keyword.repository.KeywordRepository.buildArchivedKeywordJooqMapper;
import static ru.yandex.direct.dbschema.ppc.Tables.BIDS_ARC;

@Repository
public class FlatCpcFromYtMigrationOneshotBidsArcRepository {
    private final DslContextProvider dslContextProvider;
    private final JooqMapperWithSupplier<Keyword> archivedKeywordJooqMapper;


    @Autowired
    public FlatCpcFromYtMigrationOneshotBidsArcRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
        this.archivedKeywordJooqMapper = buildArchivedKeywordJooqMapper();
    }

    public int updatePriceContextInBidsArc(int shard, List<Keyword> newKeywords) {
        if (newKeywords.isEmpty()) {
            return 0;
        }
        InsertHelper<BidsArcRecord> insertHelper = new InsertHelper<>(dslContextProvider.ppc(shard), BIDS_ARC);

        int recordsAndUpdateCount = insertHelper
                .addAll(archivedKeywordJooqMapper, newKeywords)
                .onDuplicateKeyUpdate()
                .set(BIDS_ARC.PRICE_CONTEXT, MySQLDSL.values(BIDS_ARC.PRICE_CONTEXT))
                .execute();

        // onDuplicateKeyUpdate считает каждое обновление по 2 раза, как record и как update так как мы достаём все
        // keyword'ы из той же таблички в которую и вставляем, гарантируется, что тут будет происходить именно
        // обновление
        return recordsAndUpdateCount / 2;
    }
}
