package ru.yandex.direct.oneshot.oneshots.interstitialtoinapp;

import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.bidmodifier.InventoryType;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.oneshot.worker.def.Approvers;
import ru.yandex.direct.oneshot.worker.def.Multilaunch;
import ru.yandex.direct.oneshot.worker.def.PausedStatusOnFail;
import ru.yandex.direct.oneshot.worker.def.ShardedOneshot;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.dbschema.ppc.tables.InventoryMultiplierValues.INVENTORY_MULTIPLIER_VALUES;

@Component
@Multilaunch
@PausedStatusOnFail
@Approvers({"andreypav"})
public class RenameInterstitialToInAppInventoryMultipliersOneShot implements ShardedOneshot<Void,Void> {
    private static final Logger logger = LoggerFactory.getLogger(RenameInterstitialToInAppInventoryMultipliersOneShot.class);

    private final DslContextProvider dslContextProvider;

    public RenameInterstitialToInAppInventoryMultipliersOneShot(
            DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
    }

    @Nullable
    @Override
    public Void execute(Void inputData, Void prevState, int shard) {
        logger.info("RenameInterstitialToInAppPricePackagesOneShot START");

        int updatedAmount = dslContextProvider.ppc(shard)
                .update(INVENTORY_MULTIPLIER_VALUES)
                .set(INVENTORY_MULTIPLIER_VALUES.INVENTORY_TYPE, InventoryType.toSource(InventoryType.INAPP))
                .where(INVENTORY_MULTIPLIER_VALUES.INVENTORY_TYPE.eq(InventoryType.toSource(InventoryType.INTERSTITIAL)))
                .execute();
        logger.info(String.format("Shard: %d - updated %d records", shard, updatedAmount));
        logger.info("RenameInterstitialToInAppPricePackagesOneShot FINISH");

        return null;
    }

    @Override
    public ValidationResult<Void, Defect> validate(
            Void inputData)
    {
        return ValidationResult.success(inputData);
    }
}
