package ru.yandex.direct.oneshot.oneshots.invalidpermalinks;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Nullable;

import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.oneshot.base.ShardedYtOneshot;
import ru.yandex.direct.oneshot.base.YtInputData;
import ru.yandex.direct.oneshot.base.YtState;
import ru.yandex.direct.ytwrapper.client.YtProvider;
import ru.yandex.direct.ytwrapper.model.YtCluster;
import ru.yandex.direct.ytwrapper.model.YtOperator;
import ru.yandex.direct.ytwrapper.model.YtTable;

public abstract class InvalidPermalinksOneshot extends ShardedYtOneshot<YtInputData, YtState> {

    private final long chunkSize;

    protected InvalidPermalinksOneshot(YtProvider ytProvider, long chunkSize) {
        super(ytProvider);
        this.chunkSize = chunkSize;
    }

    protected abstract void processItems(int shard, List<Pair<ClientId, Long>> items);

    protected abstract Logger getLogger();

    @Nullable
    @Override
    public YtState execute(YtInputData inputData, YtState prevState,
                           int shard) {
        YtCluster ytCluster = YtCluster.parse(inputData.getYtCluster());
        YtTable ytTable = new YtTable(inputData.getTablePath());
        YtOperator ytOperator = ytProvider.getOperator(ytCluster);

        if (prevState == null) {
            getLogger().info("First iteration, shard {}!", shard);
            prevState = new YtState()
                    .withNextRowFromYtTable(0L)
                    .withTotalRowCount(ytOperator.readTableRowCount(ytTable));
        }

        long rowCount = prevState.getTotalRowCount();
        long startRow = prevState.getNextRow();
        long endRow = Math.min(prevState.getNextRow() + chunkSize, rowCount);
        if (startRow >= rowCount) {
            getLogger().info("Last iteration, shard: {}, last processed row: {}, total rows: {}", shard, startRow, rowCount);
            return null;
        }
        try {
            InvalidPermalinkTableRow tableRow = new InvalidPermalinkTableRow();
            List<Pair<ClientId, Long>> items = new ArrayList<>((int) (endRow - startRow));

            ytOperator.readTableByRowRange(ytTable,row -> {
                        if (shard == row.getShard()) {
                            items.add(Pair.of(ClientId.fromLong(row.getClientId()), row.getPermalinkId()));
                        }
                    },
                    tableRow,
                    startRow,
                    endRow);
            processItems(shard, items);
            getLogger().info("Processed {} items, from row {} to {}, shard: {}", items.size(), startRow, endRow, shard);
        } catch (RuntimeException e) {
            getLogger().error("Caught exception on shard " + shard + ": " + e.getMessage());
            throw e;
        }
        return new YtState().withNextRowFromYtTable(endRow).withTotalRowCount(rowCount);
    }

}
