package ru.yandex.direct.oneshot.oneshots.invalidpermalinks;

import java.util.List;

import org.apache.commons.lang3.tuple.Pair;
import org.jooq.DSLContext;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.organizations.repository.OrganizationRepository;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.oneshot.worker.def.Approvers;
import ru.yandex.direct.oneshot.worker.def.Multilaunch;
import ru.yandex.direct.ytwrapper.client.YtProvider;

/**
 * Ваншот для удаления пермалинков по таблице из YTя.
 * Берет shard, ClientID и permalink_id из таблицы в YT и удаляет запись по ключу {ClientID, permalink_id} из таблицы
 * organizations в шарде shard.
 * https://st.yandex-team.ru/DIRECT-124583
 * <p>
 * Ваншот ожидает два обязательных входных параметра - строку с кластером YT, на котором лежит таблица
 * и строку с путем к таблице с данными
 */
@Component
@Approvers({"ppalex", "hmepas", "lena-san", "gerdler", "maxlog", "zhur", "kuhtich", "hrustyashko", "pavryabov"})
@Multilaunch
public class RemoveInvalidPermalinksOneshot extends InvalidPermalinksOneshot {
    private static final Logger logger = LoggerFactory.getLogger(RemoveInvalidPermalinksOneshot.class);
    private static final long CHUNK_SIZE = 1000;

    private final DslContextProvider dslContextProvider;
    private final OrganizationRepository organizationRepository;

    public RemoveInvalidPermalinksOneshot(
            YtProvider ytProvider,
            DslContextProvider dslContextProvider,
            OrganizationRepository organizationRepository
    ) {
        super(ytProvider, CHUNK_SIZE);
        this.dslContextProvider = dslContextProvider;
        this.organizationRepository = organizationRepository;
    }

    @Override
    protected void processItems(int shard, List<Pair<ClientId, Long>> items) {
        if (items.isEmpty()) {
            return;
        }
        dslContextProvider.ppc(shard).transaction(ctx -> {
            DSLContext context = DSL.using(ctx);
            organizationRepository.deleteOrganizations(context, items);
        });
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}
