package ru.yandex.direct.oneshot.oneshots.marketrescuer

import ru.yandex.direct.core.entity.adgroup.container.ComplexTextAdGroup
import ru.yandex.direct.core.entity.adgroup.model.AdGroupType
import ru.yandex.direct.core.entity.adgroup.model.TextAdGroup
import ru.yandex.direct.core.entity.banner.model.Language
import ru.yandex.direct.core.entity.banner.model.TextBanner
import ru.yandex.direct.core.entity.bidmodifier.*
import ru.yandex.direct.core.entity.campaign.model.*
import ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants
import ru.yandex.direct.core.entity.keyword.model.AutoBudgetPriority
import ru.yandex.direct.core.entity.keyword.model.Keyword
import ru.yandex.direct.core.entity.relevancematch.model.RelevanceMatch
import ru.yandex.direct.core.entity.vcard.model.Phone
import ru.yandex.direct.core.entity.vcard.model.Vcard
import ru.yandex.direct.libs.timetarget.TimeTargetUtils
import ru.yandex.direct.oneshot.oneshots.marketrescuer.GenerateBannersForMarketOneshot.Companion.transformQueryToTitle
import ru.yandex.direct.utils.UrlUtils
import java.math.BigDecimal
import java.time.LocalDate
import java.util.*


// для английского перечислил только несколько
val PREPOSITIONS = setOf("без", "безо", "близ", "в", "во", "вместо", "вне", "для", "до", "за", "из", "изо", "из-за", "из-под", "к", "ко", "кроме", "между", "меж", "на", "над", "о", "об", "обо", "от", "ото", "перед", "передо", "пред", "пред", "пo", "под", "подо", "при", "про", "ради", "с", "со", "сквозь", "среди", "у", "через", "чрез",
        "of", "on", "in", "at", "by", "above")

private const val CAMPAIGNS_EMAIL = "market-rescuers@yandex-team.ru"
private val DAY_BUDGET = BigDecimal.valueOf(100000)
private val MEANINGFUL_GOALS_CONVERSION_VALUE = BigDecimal.valueOf(2500)
private val MINUS_KEYWORDS = listOf("!как", "!каркас", "!когда", "!куплю", "!накладка", "!подголовник", "!своими", "!спинка", "!у", "!чего", "!что", "+в кредит", "1", "11", "12", "13", "139", "15", "2", "2017", "279", "2с", "3", "416", "434", "435", "5", "500", "511", "525", "635", "661", "668", "682", "685", "696", "7", "700", "727", "747", "795", "799", "8", "808", "868", "8ch", "911", "9801", "9906axsn", "9908axsn", "993", "994", "9950axsn", "a324", "ac120", "ac220", "ac80c", "aerocool", "akracing", "anissa", "arachno", "aravia", "armor", "arozzi", "atlant", "aura", "av", "avito", "baron", "betta", "bk", "black", "blanes", "boss", "brabix", "bubble", "budget", "burgos", "buro", "calviano", "care", "ch", "chair", "chairman", "charm", "college", "comfort", "corsair", "cougar", "cream", "cyber", "danger", "db", "dexp", "diabay", "dominus", "domix", "driver", "dxracer", "dxseat", "easychair", "echair", "elle", "ergo", "erick", "evo", "ex", "f1", "foot", "fundesk", "galaxy", "gehwol", "george", "grand", "gt", "gtp", "hlc", "hoff", "icar", "ikea", "inter", "iso", "jupiter", "kadis", "kb", "kd", "kiddy", "king", "leo", "libao", "lincoln", "lk", "lux", "luxe", "manager", "marrit", "max", "metta", "moisture", "navi", "neo", "new", "nickolas", "nowy", "orion", "palamos", "parma", "patrick", "playseat", "prestige", "pro", "racer", "razer", "recaro", "red", "roketas", "ru", "samba", "samurai", "sb", "scorpion", "sigma", "skinlite", "smartbuy", "square", "st", "steel", "strike", "styl", "sylwia", "t", "tesoro", "tetchair", "tgc12", "thunder", "thunderx3", "tomar", "topmax", "tw", "twister", "vertagear", "vilenta", "vincent", "vivianne", "warp", "x", "x3", "xh", "xxl", "zen", "zet", "авария", "авито", "автомобильного", "автосимулятора", "агафьи", "адмирал", "адреса", "аквапилинг", "аккорд", "аксессуары", "алвест", "алгель", "алиэкспресс", "альрик", "амбассадор", "амиго", "амортизатор", "амортизационная", "аптека", "аравия", "аренда", "аскона", "атлант", "ашан", "б", "балашиха", "барани", "барнаул", "барные", "барон", "без", "белита", "бепантен", "бесплатно", "биг", "бирюзовое", "боли", "бордовое", "боро", "босс", "боттичелли", "бу", "бумстад", "бюрократ", "вальтер", "ванночка", "варна", "варфейс", "венолгон", "венотол", "вес", "взрываются", "виватон", "видео", "виды", "вип", "вк", "владикавказ", "вниз", "втулка", "выбор", "выбрать", "высота", "габариты", "газлифт", "газовый", "газпатрон", "галакси", "гарантия", "гармония", "геволь", "германия", "гольф", "гонок", "гоночное", "гост", "гранд", "грибок", "группа", "дали", "даром", "девон", "девушка", "делаем", "деоконтроль", "депиляция", "держит", "детали", "дефекты", "дефо", "дешево", "джуно", "диабет", "диадерм", "диван", "дизайн", "директ", "директор", "дмитров", "дней", "днс", "домашних", "драйвер", "дэфо", "жизни", "жуковский", "заглушки", "заказ", "закупка", "замена", "запасные", "запчасти", "зафиксировать", "звездочка", "зеленоград", "зеленое", "идра", "изготовление", "изо", "икеа", "икея", "инвалидов", "инструкция", "интенсив", "исо", "италия", "итальянские", "йод", "какие", "какое", "капилар", "картинки", "качалка", "кв", "кемерово", "киев", "китай", "класса", "классик", "коврик", "ковш", "код", "колес", "колесики", "коломна", "комендантский", "комо", "комплектующие", "комус", "комфорт", "конструкция", "консул", "контакт", "королев", "кредит", "крепление", "крестовина", "кровать", "кухни", "лабораторный", "лайт", "лак", "лашадиных", "леруа", "лечение", "лидер", "лифт", "лица", "лорд", "лошадиная", "лучшее", "люкс", "мажу", "максидом", "малышева", "маркет", "марки", "маркус", "марс", "мартин", "массажем", "массажером", "массажное", "мастер", "материал", "махачкала", "медицинский", "мерлен", "металлическом", "металлокаркас", "метро", "метта", "механизм", "микостоп", "мильгамма", "мир", "много", "модели", "можно", "москва", "мотора", "мультиблок", "мытищи", "нави", "нагрузка", "надир", "названия", "назначение", "накидка", "наращивание", "невская", "неисправности", "немецкие", "нео", "низкая", "нова", "нога", "ногтей", "ножке", "нормавен", "нота", "нэо", "обзор", "обивка", "обновить", "обогреватель", "обтяжка", "обтянуть", "обшивка", "обшить", "одинцово", "озон", "оквэд", "окоф", "окпд", "ооо", "описание", "опора", "оптима", "оптом", "опускается", "оранжевое", "орион", "орифлейм", "ортопедическое", "основание", "отдам", "отзывы", "отложение", "отрегулировать", "отремонтировать", "офисмаг", "официальный", "папасан", "парикмахер", "парить", "патрик", "патрон", "педикюр", "педикюрное", "переделка", "перетяжка", "перетянуть", "перманент", "пианино", "пиастра", "пилот", "пк", "под", "поддержка", "подлокотники", "поднимается", "подогрев", "подольск", "подшипник", "покрытие", "поломка", "поменять", "поршень", "посад", "посетитель", "после", "поставка", "похудения", "починить", "почистить", "поясничный", "прайс", "премиум", "премьер", "престиж", "причина", "продам", "прозрачное", "производители", "производство", "протон", "пушкино", "пятилучье", "работает", "рабочее", "разборка", "размеры", "разобрать", "раскладное", "распродажа", "рассрочка", "регулировать", "регулировка", "рейсер", "рейтинг", "рекаро", "реклайнер", "ремонт", "ренбергет", "реставрация", "рецепт", "розовое", "ролики", "ротанга", "ру", "руками", "руля", "рум", "рф", "садишься", "сайты", "салатовое", "салон", "самба", "само", "самодельное", "самурай", "самые", "санитарный", "сборка", "свао", "сделать", "седралекс", "селфи", "сенатор", "сергиев", "серпухов", "сетка", "сетчатое", "сиберика", "сидушка", "сидя", "сильвия", "синхромеханизм", "сириус", "сити", "ситилинк", "склад", "складной", "сколберг", "сколько", "скрип", "скрипит", "скрувста", "сломалось", "сломанный", "службы", "смазать", "смотреть", "сн", "снилле", "со", "собрать", "соматон", "состав", "состоит", "софья", "спинки", "списание", "списать", "споррен", "срок", "стандарт", "стар", "стиль", "стоимость", "стоит", "столплит", "схема", "тандер", "твери", "теймурова", "технические", "технопоинт", "типы", "ткань", "тональный", "топ", "торкель", "требования", "троксерутин", "удэ", "украина", "улан", "ультра", "упор", "упражнения", "усилить", "условиях", "устройство", "уход", "фаберлик", "фабрика", "фабрикант", "фаворит", "феликс", "фиолетовое", "фирмы", "фортуна", "форум", "фото", "френч", "фурнитура", "хабаровск", "характеристика", "химки", "хофф", "хром", "царь", "цена", "чарли", "части", "чери", "чертежи", "чехол", "чип", "чистка", "шарман", "шерман", "ширина", "шишек", "шолль", "шоль", "шоу", "эвелин", "эво", "эйвон", "экспресс", "экстра", "электросталь", "элементы", "элитные", "эльдорадо", "эрго", "эффективный", "юла", "юлмарт", "юнитекс", "юпитер", "яндекс", "японские")
private val REGION_IDS = listOf(3L, 26L, 40L, 52L, -11193L, 102444L, -11010L, -11012L, -11024L, 2L)

private const val TITLE_EXTENSION = "Ищите на Яндекс.Маркете"
private const val BODY = "Бесплатная доставка. Кешбэк до 5% баллами и экономия для подписчиков Яндекс.Плюса."
private const val DISPLAY_HREF = "Яндекс-Маркет"
private const val URL_COMMON_PARAMS = "clid=1601&utm_campaign={campaign_name)&utm_source=yandex&utm_medium=search&utm_content=cid:{campaign_id}|gid:{gbid}|aid:{ad_id}|ph:{phrase_id}|pt:{position_type}|pn:{position}|src:{source}|st:{source_type}|cgcid:{coef_goal_context_id}&utm_term={keyword}|&adjust_t=fs3pybh&adjust_ya_click_id={logid}"


fun getTextBanner(adGroupId: Long, vcardId: Long, calloutIds: List<Long>, sitelinksSetId: Long, query: String): TextBanner {
    val href = UrlUtils.encodeUrlIfCan("https://pokupki.market.yandex.ru/search?text=$query") + "&$URL_COMMON_PARAMS"
    val title = transformQueryToTitle(query)

    return TextBanner()
            .withName(title)
            .withTitle(title)
            .withTitleExtension(TITLE_EXTENSION)
            .withBody(BODY)
            .withDisplayHref(DISPLAY_HREF)
            .withHref(href)
            .withLanguage(Language.RU_)
            .withAdGroupId(adGroupId)
            .withVcardId(vcardId)
            .withSitelinksSetId(sitelinksSetId)
            .withCalloutIds(calloutIds)
}

fun getTextAdGroup(campaignId: Long, query: String): ComplexTextAdGroup {
    return ComplexTextAdGroup()
            .withAdGroup(TextAdGroup()
                    .withCampaignId(campaignId)
                    .withName("Группа: ${transformQueryToTitle(query)}")
                    .withMinusKeywords(emptyList())
                    .withLibraryMinusKeywordsIds(emptyList())
                    .withGeo(REGION_IDS)
                    .withType(AdGroupType.BASE)
            )
            .withRelevanceMatches(listOf(RelevanceMatch()))
            .withKeywords(listOf(
                    Keyword()
                            .withPhrase(query.toLowerCase())
                            .withIsAutotargeting(false)
                            .withAutobudgetPriority(AutoBudgetPriority.HIGH.typedValue))
            )
}

fun getTextCampaign(metrikaCounters: List<Long>, meaningfulGoalIds: List<Long>, name: String): TextCampaign {
    return TextCampaign()
            .withType(CampaignType.TEXT)
            .withName(name)
            .withAttributionModel(CampaignAttributionModel.LAST_SIGNIFICANT_CLICK)
            .withStartDate(LocalDate.now())
            .withIsSimplifiedStrategyViewEnabled(false)
            .withHasExtendedGeoTargeting(false)
            .withHasTitleSubstitution(true)
            .withIsAloneTrafaretAllowed(false)
            .withHasAddMetrikaTagToUrl(true)
            .withHasAddOpenstatTagToUrl(false)
            .withMinusKeywords(MINUS_KEYWORDS)
            .withSmsTime(CampaignConstants.DEFAULT_SMS_TIME_INTERVAL)
            .withSmsFlags(EnumSet.noneOf(SmsFlag::class.java))
            .withEmail(CAMPAIGNS_EMAIL)
            .withMetrikaCounters(metrikaCounters)
            .withMeaningfulGoals(getMeaningfulGoals(meaningfulGoalIds))
//            .withBidModifiers(getBidModifiers())  // решили пока не использовать, т.к. у нас и так макс ставка
            .withEnablePausedByDayBudgetEvent(true)
            .withEnableOfflineStatNotice(true)
            .withContextLimit(CampaignConstants.MAX_CONTEXT_LIMIT)
            .withEnableCpcHold(true)
            .withEnableCompanyInfo(true)
            .withExcludePausedCompetingAds(true)
            .withHasSiteMonitoring(true)
            .withBroadMatch(BroadMatch().withBroadMatchFlag(false).withBroadMatchLimit(0))
            .withAllowedPageIds(null)
            .withAllowedDomains(null)
            .withAllowedSsp(emptyList())
            .withDayBudget(DAY_BUDGET)
            .withDayBudgetShowMode(CampaignConstants.DEFAULT_DAY_BUDGET_SHOW_MODE)
            .withStrategy(getCampaignStrategy())
            .withTimeTarget(TimeTargetUtils.defaultTimeTarget())
            .withTimeZoneId(TimeTargetUtils.DEFAULT_TIMEZONE)
            .withIsUniversal(false)
            .withIsTouch(false)
            .withIsOrderPhraseLengthPrecedenceEnabled(false)
}

private fun getBidModifiers(): List<BidModifier> {
    return listOf(
//                BidModifierRetargeting()
//                        .withType(BidModifierType.RETARGETING_MULTIPLIER)
//                        .withEnabled(true)
//                        .withRetargetingAdjustments(listOf(
//                                BidModifierRetargetingAdjustment()
//                                        .withAccessible(true)
//                                        .withPercent(150)
//                                        .withRetargetingConditionId(4763767)
//                        )),
            BidModifierDemographics()
                    .withType(BidModifierType.DEMOGRAPHY_MULTIPLIER)
                    .withEnabled(true)
                    .withDemographicsAdjustments(listOf(
                            BidModifierDemographicsAdjustment()
                                    .withAge(AgeType._0_17)
                                    .withPercent(50),
                            BidModifierDemographicsAdjustment()
                                    .withAge(AgeType._55_)
                                    .withPercent(80),
                            BidModifierDemographicsAdjustment()
                                    .withAge(AgeType._18_24)
                                    .withPercent(85),
                            BidModifierDemographicsAdjustment()
                                    .withAge(AgeType._25_34)
                                    .withPercent(110),
                            BidModifierDemographicsAdjustment()
                                    .withAge(AgeType._35_44)
                                    .withPercent(115),
                            BidModifierDemographicsAdjustment()
                                    .withAge(AgeType._45_54)
                                    .withPercent(115))
                    ),
            BidModifierMobile()
                    .withType(BidModifierType.MOBILE_MULTIPLIER)
                    .withEnabled(true)
                    .withMobileAdjustment(BidModifierMobileAdjustment().withPercent(50)),
            BidModifierGeo()
                    .withType(BidModifierType.GEO_MULTIPLIER)
                    .withEnabled(true)
                    .withRegionalAdjustments(listOf(
                            BidModifierRegionalAdjustment()
                                    .withRegionId(39)
                                    .withPercent(220)
                                    .withHidden(false),
                            BidModifierRegionalAdjustment()
                                    .withRegionId(43)
                                    .withPercent(220)
                                    .withHidden(false),
                            BidModifierRegionalAdjustment()
                                    .withRegionId(54)
                                    .withPercent(220)
                                    .withHidden(false)
                    ))
    )
}

private fun getMeaningfulGoals(meaningfulGoalIds: List<Long>): List<MeaningfulGoal> {
    return meaningfulGoalIds
            .map {
                MeaningfulGoal()
                        .withGoalId(it)
                        .withConversionValue(MEANINGFUL_GOALS_CONVERSION_VALUE)
            }
            .toList()
}

private fun getCampaignStrategy(): DbStrategy {
    val dbStrategy = DbStrategy()
    dbStrategy.withPlatform(CampaignsPlatform.SEARCH)
    dbStrategy.withStrategyName(StrategyName.DEFAULT_)
    dbStrategy.withAutobudget(CampaignsAutobudget.NO)
    dbStrategy.withStrategyData(StrategyData().withName("default").withVersion(1))
    return dbStrategy
}

fun getVcard(campaignId: Long): Vcard {
    return Vcard()
            .withCampaignId(campaignId)
            .withCompanyName("ООО \"Яндекс.Маркет\"")
            .withWorkTime("0#6#00#00#00#00")
            .withPhone(Phone()
                    .withCountryCode("8")
                    .withCityCode("800")
                    .withPhoneNumber("2342712"))
            .withCountry("Россия")
            .withCity("Москва")
            .withStreet("Новинский бульвар")
            .withHouse("8")
}
