package ru.yandex.direct.oneshot.oneshots.minus_geo_to_flags

import org.slf4j.LoggerFactory
import org.springframework.stereotype.Component
import ru.yandex.direct.dbschema.ppc.Tables.BS_RESYNC_QUEUE
import ru.yandex.direct.dbutil.sharding.ShardHelper
import ru.yandex.direct.dbutil.wrapper.DslContextProvider
import ru.yandex.direct.oneshot.base.SimpleOneshotWithoutInput
import ru.yandex.direct.oneshot.worker.def.Approvers
import ru.yandex.direct.oneshot.worker.def.Multilaunch
import ru.yandex.direct.oneshot.worker.def.PausedStatusOnFail
import ru.yandex.direct.oneshot.worker.def.Retries
import java.time.LocalDateTime

@Component
@Multilaunch
@PausedStatusOnFail
@Retries(5)
@Approvers("mspirit", "elwood", "volodskikh", "ppalex", "a-beliakov")
class ChangeBsResyncPriorityOneshot(
    private val shardHelper: ShardHelper,
    private val dslContextProvider: DslContextProvider,
) : SimpleOneshotWithoutInput() {
    companion object {
        private val logger = LoggerFactory.getLogger(ChangeBsResyncPriorityOneshot::class.java)
    }

    override fun execute() {
        for (shard in shardHelper.dbShards()) {
            do {
                logger.info("Processing next rows in shard $shard")
                val rows = dslContextProvider.ppc(shard)
                    .update(BS_RESYNC_QUEUE)
                    .set(BS_RESYNC_QUEUE.PRIORITY, 88)
                    .where(
                        BS_RESYNC_QUEUE.PRIORITY.eq(89)
                            .and(BS_RESYNC_QUEUE.SEQUENCE_TIME.lessThan(LocalDateTime.of(2022, 7, 27, 19, 0, 0)))
                    )
                    .limit(50_000)
                    .execute()
                logger.info("Updated $rows rows")
                if (rows > 0) {
                    val relaxTimeSec = 10L
                    logger.info("Sleep for $relaxTimeSec seconds")
                    Thread.sleep(relaxTimeSec * 1000)
                }
            } while (rows > 0)
        }
    }
}
