package ru.yandex.direct.oneshot.oneshots.overdraft;

import javax.annotation.Nullable;

import org.springframework.stereotype.Component;

import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.oneshot.worker.def.Approvers;
import ru.yandex.direct.oneshot.worker.def.Multilaunch;
import ru.yandex.direct.oneshot.worker.def.ShardedOneshot;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.dbschema.ppc.Tables.CLIENT_OVERDRAFT_LIMIT_CHANGES;

/**
 * Безусловная очистка таблицы ppc.client_overdraft_limit_changes
 * от накопленных за время простоя джобы OverdraftLimitChangesMailerJob данных
 */
@Component
@Multilaunch
@Approvers({"mexicano", "ppalex", "gerdler", "kuhtich"})
public class ClearClientOverdraftLimitChangesTable implements ShardedOneshot<Void, Void> {
    private final DslContextProvider dslContextProvider;

    public ClearClientOverdraftLimitChangesTable(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
    }

    @Override
    @SuppressWarnings("rawtypes")
    public ValidationResult<Void, Defect> validate(Void inputData) {
        return ValidationResult.success(inputData);
    }

    @Nullable
    @Override
    public Void execute(Void ignored, Void ignoredState, int shard) {
        dslContextProvider.ppc(shard).truncate(CLIENT_OVERDRAFT_LIMIT_CHANGES).execute();
        return null;
    }
}
