package ru.yandex.direct.oneshot.oneshots.package_strategy_migration

import ru.yandex.direct.validation.builder.Constraint
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.builder.When
import ru.yandex.direct.validation.constraint.CommonConstraints
import ru.yandex.direct.validation.defect.CollectionDefects.notInCollection
import ru.yandex.direct.validation.defect.CommonDefects
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.util.property
import ru.yandex.direct.validation.util.validateObject
import ru.yandex.direct.ytwrapper.model.YtCluster

class InputDataValidator<T : BaseInputData>(private val tableExists: (String) -> Boolean) : Validator<T, Defect<*>> {
    override fun apply(inputData: T): ValidationResult<T, Defect<*>> {
        val supportedClusters = YtCluster.values().map { it.getName() }.toSet()
        return validateObject(inputData) {
            property(BaseInputData::ytCluster) {
                check(CommonConstraints.notNull())
                check(
                    Constraint.fromPredicate(
                        { name -> supportedClusters.contains(name.lowercase()) },
                        notInCollection()
                    )
                )
            }
            property(BaseInputData::tablePath) {
                check(CommonConstraints.notNull())
                check(Constraint.fromPredicate({ tableExists(it) }, CommonDefects.objectNotFound()), When.isValid())
            }
            if (inputData is CampaignToPackageStrategyMigrationOneShot.Companion.InputData) {
                property(inputData::operatorUid) {
                    check(CommonConstraints.notNull())
                }
            }
        }
    }
}
