package ru.yandex.direct.oneshot.oneshots.package_strategy_migration

import org.jooq.DSLContext
import org.springframework.stereotype.Component
import ru.yandex.direct.autobudget.restart.repository.CampRestartData
import ru.yandex.direct.autobudget.restart.repository.CampaignAutobudgetRestartRepository
import ru.yandex.direct.autobudget.restart.repository.PackageStrategyAutobudgetRestartRepository
import ru.yandex.direct.autobudget.restart.repository.RestartTimes
import ru.yandex.direct.autobudget.restart.repository.StrategyRestartData
import ru.yandex.direct.autobudget.restart.service.StrategyState
import ru.yandex.direct.core.entity.strategy.model.CommonStrategy
import ru.yandex.direct.core.entity.strategy.repository.StrategyTypedRepository
import ru.yandex.direct.core.entity.strategy.service.PublicPackageStrategyAutobudgetRestartService.Companion.toStrategyDto
import ru.yandex.direct.dbutil.wrapper.DslContextProvider

@Component
class StrategyAutobudgetMigrationService(
    private val dslContextProvider: DslContextProvider,
    private val strategyTypedRepository: StrategyTypedRepository,
    private val campaignAutobudgetRestartRepository: CampaignAutobudgetRestartRepository,
    private val strategyAutobudgetRestartRepository: PackageStrategyAutobudgetRestartRepository
) {

    fun migrate(
        shard: Int,
        strategyIdByCid: Map<Long, Long>,
        rewriteOnDuplicate: Boolean
    ) {
        dslContextProvider.ppcTransaction(shard) { configuration ->
            val dslContext = configuration.dsl()
            //Берем лок на записи из camp_autobudget_restart
            val campaignRestarts = getCampaignRestarts(dslContext, strategyIdByCid.keys.toList())
            val strategiesById = getStrategies(dslContext, strategyIdByCid.values.toList().distinct())
            val strategyRestartData = getStrategyRestartData(
                strategyIdByCid,
                campaignRestarts,
                strategiesById
            )
            strategyAutobudgetRestartRepository.saveAutobudgetRestartData(
                dslContext,
                strategyRestartData,
                doUpdateOnDuplicate = rewriteOnDuplicate
            )
        }
    }

    private fun getCampaignRestarts(
        dslContext: DSLContext,
        cids: List<Long>
    ): Map<Long, CampRestartData> {
        return campaignAutobudgetRestartRepository
            .getAutobudgetRestartData(dslContext, cids, true)
            .associateBy { it.cid }
    }

    private fun getStrategies(dslContext: DSLContext, strategyIds: List<Long>): Map<Long, CommonStrategy> {
        return strategyTypedRepository.getTyped(
            dslContext,
            strategyIds
        ).mapNotNull { it as? CommonStrategy }
            .filter { it.isPublic == false }
            .associateBy { it.id }
    }

    private fun getStrategyRestartData(
        strategyIdByCid: Map<Long, Long>,
        campaignRestartDataById: Map<Long, CampRestartData>,
        strategiesById: Map<Long, CommonStrategy>
    ): List<StrategyRestartData> =
        campaignRestartDataById.mapNotNull { (cid, campRestartData) ->
            val strategyId = strategyIdByCid[cid]
            strategyId?.let {
                buildStrategyRestartData(
                    campRestartData.times,
                    campRestartData.state,
                    campRestartData.strategyData.hasMoney ?: false,
                    strategiesById[it]
                )
            }
        }

    private fun buildStrategyRestartData(
        times: RestartTimes,
        state: StrategyState,
        hasMoney: Boolean,
        strategy: CommonStrategy?,
    ): StrategyRestartData? =
        strategy?.let {
            StrategyRestartData(
                it.id,
                toStrategyDto(hasMoney, it),
                times,
                state
            )
        }
}
