package ru.yandex.direct.oneshot.oneshots.package_strategy_migration;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.jooq.Query;
import org.springframework.stereotype.Repository;

import static ru.yandex.direct.dbschema.ppc.Tables.STRATEGIES;
import static ru.yandex.direct.dbschema.ppc.Tables.STRATEGY_METRIKA_COUNTERS;
import static ru.yandex.direct.dbschema.ppc.Tables.STRATEGY_OPTIONS;

@Repository
@ParametersAreNonnullByDefault
public class StrategyCommonDeleteRepository {

    public void delete(DSLContext dslContext, List<Long> modelIds) {
        var deleteFromStrategies =
                dslContext.deleteFrom(STRATEGIES)
                        .where(STRATEGIES.STRATEGY_ID.in(modelIds));
        var deleteFromMetrikaCounters =
                dslContext.deleteFrom(STRATEGY_METRIKA_COUNTERS)
                        .where(STRATEGY_METRIKA_COUNTERS.STRATEGY_ID.in(modelIds));
        var deleteFromOpts =
                dslContext.deleteFrom(STRATEGY_OPTIONS)
                        .where(STRATEGY_OPTIONS.STRATEGY_ID.in(modelIds));

        List<Query> toDelete = new ArrayList<>();

        toDelete.add(deleteFromStrategies);
        toDelete.add(deleteFromMetrikaCounters);
        toDelete.add(deleteFromOpts);

        dslContext.batch(toDelete).execute();
    }

}
