package ru.yandex.direct.oneshot.oneshots.package_strategy_migration

import ru.yandex.direct.dbutil.wrapper.DslContextProvider
import ru.yandex.direct.operation.Applicability
import ru.yandex.direct.operation.operationwithid.AbstractOperationWithId
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

class StrategyDeleteOperation(modelIds: List<Long>,
                              private val shard: Int,
                              private val ppcDslContextProvider: DslContextProvider,
                              private val strategyCommonDeleteRepository: StrategyCommonDeleteRepository) : AbstractOperationWithId(Applicability.FULL, modelIds) {
    override fun validate(ids: List<Long>): ValidationResult<List<Long>, Defect<Any>> {
        return ValidationResult.success(ids)
    }

    override fun execute(ids: List<Long>) {
        if (ids.isEmpty()) {
            return
        }
        ppcDslContextProvider.ppcTransaction(shard) { config ->
            val context = config.dsl()

            strategyCommonDeleteRepository.delete(
                context,
                ids
            )
        }
    }
}
