package ru.yandex.direct.oneshot.oneshots.package_strategy_migration;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.stereotype.Repository;

import static ru.yandex.direct.dbschema.ppcdict.tables.ShardIncStrategyId.SHARD_INC_STRATEGY_ID;

@Repository
@ParametersAreNonnullByDefault
public class StrategyPpcDictDeleteRepository {

    public void delete(DSLContext dslContext, List<Long> modelIds) {
        if (modelIds.isEmpty()) {
            return;
        }
        var query = dslContext.deleteFrom(SHARD_INC_STRATEGY_ID)
                .where(SHARD_INC_STRATEGY_ID.STRATEGY_ID.in(modelIds));

        query.execute();
    }
}
