package ru.yandex.direct.oneshot.oneshots.remoderateperfcampaigns

import com.fasterxml.jackson.annotation.JsonProperty
import org.slf4j.LoggerFactory
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component
import ru.yandex.direct.dbschema.ppc.Tables
import ru.yandex.direct.dbschema.ppc.enums.CampaignsStatusmoderate
import ru.yandex.direct.dbutil.sharding.ShardHelper
import ru.yandex.direct.dbutil.sharding.ShardKey
import ru.yandex.direct.dbutil.wrapper.DslContextProvider
import ru.yandex.direct.oneshot.worker.def.Approvers
import ru.yandex.direct.oneshot.worker.def.Multilaunch
import ru.yandex.direct.oneshot.worker.def.SimpleOneshot
import ru.yandex.direct.validation.builder.ItemValidationBuilder
import ru.yandex.direct.validation.constraint.CollectionConstraints
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import java.time.LocalDateTime

class InputData {
    @JsonProperty("campaignIds")
    var campaignIds: List<Long>? = null
}

@Component
@Multilaunch
@Approvers("mspirit")
class RemoderatePerfCampaignsOneshot @Autowired constructor(
    private val dslContextProvider: DslContextProvider,
    private val shardHelper: ShardHelper
) : SimpleOneshot<InputData, Void> {
    override fun execute(inputData: InputData?, prevState: Void?): Void? {
        val shardedData = shardHelper.groupByShard(inputData!!.campaignIds, ShardKey.CID)
        shardedData.forEach { shard: Int, campaignIds: List<Long> ->
            logger.info("Processing shard $shard")
            dslContextProvider.ppc(shard)
                .update(Tables.CAMPAIGNS)
                .set(Tables.CAMPAIGNS.STATUS_MODERATE, CampaignsStatusmoderate.Ready)
                .where(Tables.CAMPAIGNS.CID.`in`(campaignIds))
                .execute()
            var insertStep = dslContextProvider.ppc(shard)
                .insertInto(Tables.MOD_EXPORT_QUEUE)
                .columns(
                    Tables.MOD_EXPORT_QUEUE.CID,
                    Tables.MOD_EXPORT_QUEUE.QUEUE_TIME,
                    Tables.MOD_EXPORT_QUEUE.PAR_ID,
                    Tables.MOD_EXPORT_QUEUE.CAMPS_NUM
                )
            val startTime = LocalDateTime.now()
            for (campaignId in campaignIds) {
                insertStep = insertStep.values(campaignId, startTime, null, 1L)
            }
            insertStep
                .onDuplicateKeyIgnore()
                .execute()
        }
        logger.info("Finished OK")
        return null
    }

    override fun validate(inputData: InputData): ValidationResult<InputData, Defect<Any>> {
        val vb = ItemValidationBuilder.of<InputData, Defect<Any>>(inputData)
        vb.item(inputData.campaignIds, "campaignIds")
            .check(CollectionConstraints.notEmptyCollection())
        return vb.result
    }

    companion object {
        private val logger = LoggerFactory.getLogger(RemoderatePerfCampaignsOneshot::class.java)
    }
}
