package ru.yandex.direct.oneshot.oneshots.removeunusedbidmodifiers;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import ru.yandex.direct.dbschema.ppc.enums.HierarchicalMultipliersType;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.oneshot.base.ShardedOneshotWithoutInput;
import ru.yandex.direct.oneshot.worker.def.Approvers;

import static ru.yandex.direct.dbschema.ppc.Tables.EXPRESSION_MULTIPLIER_VALUES;
import static ru.yandex.direct.dbschema.ppc.Tables.HIERARCHICAL_MULTIPLIERS;

@Component
@Approvers({"andreypav"})
public class RemoveUnusedBidModifiers extends ShardedOneshotWithoutInput {

    private static final Logger logger = LoggerFactory.getLogger(RemoveUnusedBidModifiers.class);

    private final DslContextProvider dslContextProvider;

    public RemoveUnusedBidModifiers(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
    }

    @Override
    public void execute(int shard) {

        List<Long> fetch = dslContextProvider.ppc(shard)
                .select(HIERARCHICAL_MULTIPLIERS.HIERARCHICAL_MULTIPLIER_ID)
                .from(HIERARCHICAL_MULTIPLIERS)
                .where(HIERARCHICAL_MULTIPLIERS.TYPE.in(HierarchicalMultipliersType.express_traffic_multiplier,
                        HierarchicalMultipliersType.express_content_duration_multiplier))
                .fetch(HIERARCHICAL_MULTIPLIERS.HIERARCHICAL_MULTIPLIER_ID);

        dslContextProvider.ppc(shard)
                .deleteFrom(EXPRESSION_MULTIPLIER_VALUES)
                .where(EXPRESSION_MULTIPLIER_VALUES.HIERARCHICAL_MULTIPLIER_ID.in(fetch))
                .execute();
        logger.info("Deleted {} from expression_multiplier_values with hierarchical_multiplier_id = {}", fetch.size(), fetch);
        dslContextProvider.ppc(shard)
                .deleteFrom(HIERARCHICAL_MULTIPLIERS)
                .where(HIERARCHICAL_MULTIPLIERS.HIERARCHICAL_MULTIPLIER_ID.in(fetch))
                .execute();
        logger.info("Deleted {} from hierarchical_multipliers with hierarchical_multipliers_id = {}", fetch.size(), fetch);

    }

}
