package ru.yandex.direct.oneshot.oneshots.resend_image_banners_in_old_scheme.repository

import org.jooq.impl.DSL
import org.jooq.impl.DSL.concat
import org.springframework.stereotype.Repository
import ru.yandex.direct.core.entity.banner.model.BannerImageOpts
import ru.yandex.direct.dbschema.ppc.Tables.BANNERS
import ru.yandex.direct.dbschema.ppc.Tables.BANNER_IMAGES
import ru.yandex.direct.dbschema.ppc.enums.BannersStatusarch
import ru.yandex.direct.dbutil.wrapper.DslContextProvider
import ru.yandex.direct.oneshot.oneshots.resend_image_banners_in_old_scheme.BannerImageData

@Repository
class ResendImageBannersInOldSchemeRepository(
    private val dslContextProvider: DslContextProvider,
) {

    /**
     * Получает id картиночных баннеров, у которых выставлен флаг SINGLE_AD_TO_BS (отправлен в БК виде одного баннера)
     */
    fun getImageBannerIdsWithSingleAdFlag(
        shard: Int,
        campaignId: Long,
        fromImageId: Long,
        limit: Int,
    ): Map<Long, List<BannerImageData>> = dslContextProvider.ppc(shard)
        .select(BANNERS.PID, BANNERS.BID, BANNER_IMAGES.IMAGE_ID)
        .from(BANNER_IMAGES)
        .join(BANNERS).on(BANNERS.BID.eq(BANNER_IMAGES.BID))
        .where(BANNERS.CID.eq(campaignId))
        .and(BANNERS.STATUS_ARCH.ne(BannersStatusarch.Yes))
        .and(BANNER_IMAGES.OPTS.contains(BannerImageOpts.SINGLE_AD_TO_BS.getTypedValue()))
        .and(BANNER_IMAGES.IMAGE_ID.greaterThan(fromImageId))
        .orderBy(BANNER_IMAGES.IMAGE_ID)
        .limit(limit)
        .fetchGroups(BANNERS.PID) { (_, bid, imageId) -> BannerImageData(bid, imageId) }

    /**
     * Удаляет у картиночных баннеров флаг SINGLE_AD_TO_BS и сбрасывает БК'ный bannerId
     */
    fun removeBannerIdAndSingleAdFlagFromImageBanner(
        shard: Int,
        imageIds: Set<Long>,
    ) {
        val comma = DSL.`val`(",")

        dslContextProvider.ppc(shard)
            .update(BANNER_IMAGES)
            .set(BANNER_IMAGES.BANNER_ID, 0)
            .set(
                BANNER_IMAGES.OPTS,
                DSL.trim(
                    concat(comma, BANNER_IMAGES.OPTS, comma)
                        .replace(DSL.`val`("," + BannerImageOpts.SINGLE_AD_TO_BS.typedValue + ","), comma),
                    comma
                )
            )
            .where(BANNER_IMAGES.IMAGE_ID.`in`(imageIds))
            .and(BANNER_IMAGES.OPTS.contains(BannerImageOpts.SINGLE_AD_TO_BS.typedValue))
            .execute()
    }
}
