package ru.yandex.direct.oneshot.oneshots.resendingfeedtobannerland;

import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.dbschema.ppc.enums.FeedsUpdateStatus;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.oneshot.worker.def.Approvers;
import ru.yandex.direct.oneshot.worker.def.ShardedOneshot;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.dbschema.ppc.Tables.FEEDS;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.direct.validation.constraint.CommonConstraints.validId;

/**
 * https://st.yandex-team.ru/DIRECT-129553
 * Входные данные: feedId для переотправки в BannerLand.
 */
@Component
@Approvers({"sco76", "gukserg"})
public class ResendingFeedToBannerLandOneshot implements ShardedOneshot<ResendingFeedToBannerLandOneshotData, Void> {

    private static final Logger logger = LoggerFactory.getLogger(ResendingFeedToBannerLandOneshot.class);
    private final DslContextProvider dslContextProvider;

    @Autowired
    public ResendingFeedToBannerLandOneshot(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
    }

    @Nullable
    @Override
    public Void execute(ResendingFeedToBannerLandOneshotData inputData, Void prevState, int shard) {

        int updatedRecordsCount = dslContextProvider.ppc(shard)
                .update(FEEDS)
                .set(FEEDS.UPDATE_STATUS, FeedsUpdateStatus.New)
                .where(FEEDS.FEED_ID.eq(inputData.getFeedId()))
                .execute();

        logger.info("The number of updated records at shard {}: {}", shard, updatedRecordsCount);
        return null;
    }

    @Override
    public ValidationResult<ResendingFeedToBannerLandOneshotData, Defect> validate(ResendingFeedToBannerLandOneshotData inputData) {

        ItemValidationBuilder<ResendingFeedToBannerLandOneshotData, Defect> builder =
                ItemValidationBuilder.of(inputData);

        builder.item(inputData.getFeedId(), "feedId")
                .check(notNull())
                .check(validId());

        return builder.getResult();
    }
}
