package ru.yandex.direct.oneshot.oneshots.reset_no_title_substitute;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.campaign.model.BaseCampaign;
import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.campaign.repository.CampaignTypedRepository;
import ru.yandex.direct.dbschema.ppc.enums.CampaignsType;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.multitype.entity.LimitOffset;
import ru.yandex.direct.multitype.repository.filter.Filter;

import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS;
import static ru.yandex.direct.multitype.repository.filter.ConditionFilterFactory.greaterThan;
import static ru.yandex.direct.multitype.repository.filter.ConditionFilterFactory.multipleConditionFilter;
import static ru.yandex.direct.multitype.repository.filter.ConditionFilterFactory.setFieldContains;
import static ru.yandex.direct.multitype.repository.filter.ConditionFilterFactory.whereInFilter;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Repository
@ParametersAreNonnullByDefault
public class ResetNoTitleSubstituteFlagFromCampaignsRepository {
    private final DslContextProvider dslContextProvider;
    private final CampaignTypedRepository campaignTypedRepository;

    @Autowired
    public ResetNoTitleSubstituteFlagFromCampaignsRepository(DslContextProvider dslContextProvider,
                                                             CampaignTypedRepository campaignTypedRepository) {
        this.dslContextProvider = dslContextProvider;
        this.campaignTypedRepository = campaignTypedRepository;
    }

    public List<BaseCampaign> getCampaignsWithOptionAndIdGreaterThan(
            int shard, Long campaignId, String option, List<CampaignType> typesForOption, int limit) {
        List<CampaignsType> campaignsTypes = mapList(typesForOption, CampaignType::toSource);
        Filter filter = multipleConditionFilter(greaterThan(CAMPAIGNS.CID, campaignId),
                whereInFilter(CAMPAIGNS.TYPE, campaignsTypes),
                setFieldContains(CAMPAIGNS.OPTS, option));
        DSLContext dslContext = dslContextProvider.ppc(shard);
        return campaignTypedRepository.getTypedCampaigns(dslContext, filter, LimitOffset.limited(limit));
    }
}
