package ru.yandex.direct.oneshot.oneshots.segmentstatus;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.dbschema.ppc.enums.VideoSegmentGoalsExternalAudienceStatus;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.oneshot.base.ShardedOneshotWithoutInput;
import ru.yandex.direct.oneshot.worker.def.Approvers;
import ru.yandex.direct.oneshot.worker.def.Multilaunch;

import static ru.yandex.direct.dbschema.ppc.Tables.VIDEO_SEGMENT_GOALS;

@Component
@Multilaunch
@Approvers({"yarashid", "mexicano", "hrustyashko"})
public class SegmentStatusRecoverOneshot extends ShardedOneshotWithoutInput {

    private final DslContextProvider dslContextProvider;

    @Autowired
    public SegmentStatusRecoverOneshot(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
    }

    @Override
    protected void execute(int shard) {
        dslContextProvider.ppc(shard)
                .update(VIDEO_SEGMENT_GOALS)
                .set(VIDEO_SEGMENT_GOALS.EXTERNAL_AUDIENCE_STATUS, VideoSegmentGoalsExternalAudienceStatus.processed)
                .where(VIDEO_SEGMENT_GOALS.EXTERNAL_AUDIENCE_STATUS.eq(VideoSegmentGoalsExternalAudienceStatus.is_processed))
                .execute();
    }
}
