package ru.yandex.direct.oneshot.oneshots.simple;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import ru.yandex.direct.oneshot.worker.def.Multilaunch;
import ru.yandex.direct.oneshot.worker.def.SafeOneshot;
import ru.yandex.direct.oneshot.worker.def.SimpleOneshot;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.direct.validation.constraint.StringConstraints.minStringLength;
import static ru.yandex.direct.validation.constraint.StringConstraints.notBlank;

@Component
@Multilaunch
@SafeOneshot
public class TestSimpleOneshot implements SimpleOneshot<InputData, State> {
    private static final Logger logger = LoggerFactory.getLogger(TestSimpleOneshot.class);

    @Override
    public ValidationResult<InputData, Defect> validate(InputData inputData) {
        ItemValidationBuilder<InputData, Defect> ivb = ItemValidationBuilder.of(inputData);
        ivb.item(inputData.getData(), "data")
                .check(notNull())
                .check(notBlank())
                .check(minStringLength(4));
        return ivb.getResult();
    }

    @Override
    public State execute(InputData inputData, State state) {
        if (state == null) {
            logger.info("First iteration! input data: {}", inputData.getData());
            sleep();
            return new State().withIteration(1);
        }

        if (state.getIteration() >= 5) {
            logger.info("Last iteration: {}, input data: {}", state.getIteration(), inputData.getData());
            sleep();
            return null;
        } else {
            logger.info("Iteration: {}, input data: {}", state.getIteration(), inputData.getData());
            sleep();
            return state.withIteration(state.getIteration() + 1);
        }
    }

    private void sleep() {
        try {
            Thread.sleep(10_000);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}
