package ru.yandex.direct.oneshot.oneshots.smartchangestrategy.repository;

import java.time.LocalDateTime;

import javax.annotation.ParametersAreNonnullByDefault;

import org.apache.commons.lang3.tuple.Pair;
import org.jooq.DSLContext;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.campaign.model.CampOptionsStrategy;
import ru.yandex.direct.core.entity.campaign.model.Campaign;
import ru.yandex.direct.core.entity.campaign.model.StrategyName;
import ru.yandex.direct.dbschema.ppc.enums.CampaignsType;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.utils.JsonUtils;

import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS;
import static ru.yandex.direct.dbschema.ppc.Tables.CAMP_OPTIONS;

@Repository
@ParametersAreNonnullByDefault
public class OneshotCampaignRepository {

    public Pair<Long, Long> getMinAndMaxSmartCampaignId(DslContextProvider dslContextProvider, int shard) {
        DSLContext dslContext = dslContextProvider.ppc(shard);
        Long minCampaignId = dslContext
                .select(CAMPAIGNS.CID)
                .from(CAMPAIGNS)
                .where(CAMPAIGNS.TYPE.eq(CampaignsType.performance))
                .orderBy(CAMPAIGNS.CID)
                .limit(1)
                .fetchOne(CAMPAIGNS.CID);
        Long maxCampaignId = dslContext
                .select(CAMPAIGNS.CID)
                .from(CAMPAIGNS)
                .where(CAMPAIGNS.TYPE.eq(CampaignsType.performance))
                .orderBy(CAMPAIGNS.CID.desc())
                .limit(1)
                .fetchOne(CAMPAIGNS.CID);
        return Pair.of(minCampaignId, maxCampaignId);
    }

    public boolean updateCampaignStrategy(DSLContext dslContext, Campaign campaign) {
        return dslContext.update(CAMPAIGNS
                .join(CAMP_OPTIONS).on(CAMPAIGNS.CID.eq(CAMP_OPTIONS.CID)))
                .set(CAMPAIGNS.STRATEGY_NAME, StrategyName.toSource(campaign.getStrategy().getStrategyName()))
                .set(CAMPAIGNS.STRATEGY_DATA, JsonUtils.toJson(campaign.getStrategy().getStrategyData()))
                .set(CAMPAIGNS.LAST_CHANGE, LocalDateTime.now())
                .set(CAMP_OPTIONS.STRATEGY, CampOptionsStrategy.toSource(campaign.getStrategy().getStrategy()))
                .where(CAMPAIGNS.CID.eq(campaign.getId()))
                .execute() > 0;
    }
}
