package ru.yandex.direct.oneshot.oneshots.uc

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.client.repository.ClientRepository
import ru.yandex.direct.core.entity.uac.grut.GrutTransactionProvider
import ru.yandex.direct.core.entity.uac.service.UacBannerService
import ru.yandex.direct.core.entity.uac.service.appinfo.ParseAppStoreUrlService
import ru.yandex.direct.core.entity.uac.service.trackingurl.ParserType
import ru.yandex.direct.core.entity.uac.service.trackingurl.TrackingUrlParseService
import ru.yandex.direct.core.grut.replication.GrutApiService
import ru.yandex.direct.dbutil.sharding.ShardHelper
import ru.yandex.direct.oneshot.worker.def.Approvers
import ru.yandex.direct.oneshot.worker.def.Multilaunch
import ru.yandex.direct.oneshot.worker.def.PausedStatusOnFail
import ru.yandex.direct.oneshot.worker.def.Retries
import ru.yandex.direct.ytwrapper.client.YtProvider

/**
 * Ваншот проверяет список заявок на основе таблицы YT из входных параметров на предмет соответствия кликовой и
 * VTA ссылок, если обнаружено противоречие, то ваншот попытается сгенерировать VTA ссылку на основе кликовой
 * (если это возможно), далее поврежденные данные будут заменены либо на верную VTA ссылку, либо будут занулены.
 *
 *  Пример входных данных: {"ytCluster": "HAHN", "tablePath": "//home/direct/test/table", "chunk": 1, "lastRow": 0},
 *  где таблица из tablePath должна содержать одну колонку с именем "cid", которая содержит id кампаний для проверки.
 */
@Component
@Approvers("pavelkataykin", "khuzinazat", "bratgrim")
@Retries(5)
@Multilaunch
@PausedStatusOnFail
class FixUnmatchedTrackingUrlAndVTAOneshot(
    private val trackingUrlParseService: TrackingUrlParseService,
    ytProvider: YtProvider,
    parseAppStoreUrlService: ParseAppStoreUrlService,
    grutApiService: GrutApiService,
    ydbGrutConverterYtRepository: YdbGrutConverterYtRepository,
    uacBannerService: UacBannerService,
    shardHelper: ShardHelper,
    clientRepository: ClientRepository,
    grutTransactionProvider: GrutTransactionProvider
) : BaseFixBrokenImpressionUrlOneshot(
    ytProvider,
    trackingUrlParseService,
    parseAppStoreUrlService,
    grutApiService,
    ydbGrutConverterYtRepository,
    uacBannerService,
    shardHelper,
    clientRepository,
    grutTransactionProvider,
) {

    override fun impressionHasError(impressionUrl: String?, trackingUrl: String?): Boolean {
        if (impressionUrl == null || trackingUrl == null) return false
        val trackingUrlSystem = trackingUrlParseService.getTrackingSystem(trackingUrl, ParserType.TRACKING_URL)

        val impressionUrlSystem = trackingUrlParseService.getTrackingSystem(impressionUrl, ParserType.IMPRESSION_URL)
        return impressionUrlSystem != null
            && trackingUrlSystem != null
            && impressionUrlSystem != trackingUrlSystem
    }
}
