package ru.yandex.direct.oneshot.oneshots.uc.repository

import org.springframework.stereotype.Repository
import ru.yandex.direct.dbschema.ppc.Tables.BANNERS
import ru.yandex.direct.dbschema.ppc.enums.BannersStatusarch
import ru.yandex.direct.dbschema.ppc.enums.BannersStatusshow
import ru.yandex.direct.dbutil.wrapper.DslContextProvider

@Repository
class OneshotUacBannerRepository constructor(
    private val dslContextProvider: DslContextProvider,
) {

    fun fixDefectArchivedBannersForCampaigns(
        shard: Int,
        campaignIds: Collection<Long>,
    ): Int {
        return dslContextProvider.ppc(shard)
            .update(BANNERS)
            .set(BANNERS.STATUS_SHOW, BannersStatusshow.No)
            .where(BANNERS.CID.`in`(campaignIds)
                .and(BANNERS.STATUS_ARCH.eq(BannersStatusarch.Yes))
                .and(BANNERS.STATUS_SHOW.eq(BannersStatusshow.Yes)))
            .execute()
    }
}

