package ru.yandex.direct.oneshot.oneshots.updatecreativesgeo;

import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.dbschema.ppc.enums.PerfCreativesCreativeType;
import ru.yandex.direct.dbschema.ppc.enums.PerfCreativesStatusmoderate;

import static org.jooq.impl.DSL.choose;
import static ru.yandex.direct.dbschema.ppc.Tables.PERF_CREATIVES;

@Repository
@ParametersAreNonnullByDefault
public class CreativesRepository {

    public void updateCreativesGeo(DSLContext context, Map<Long, String> geoByCreativeId) {
        if (geoByCreativeId.isEmpty()) {
            return;
        }

        context.update(PERF_CREATIVES)
                .set(PERF_CREATIVES.SUM_GEO,
                        choose(PERF_CREATIVES.CREATIVE_ID).mapValues(geoByCreativeId).otherwise(PERF_CREATIVES.SUM_GEO))
                .where(PERF_CREATIVES.CREATIVE_ID.in(geoByCreativeId.keySet()))
                .execute();
    }

    public Map<Long, List<Long>> getCreativeIdsToClientIds(DSLContext context, int batchSize, Long startId) {
        return context.select(PERF_CREATIVES.CLIENT_ID, PERF_CREATIVES.CREATIVE_ID)
                .from(PERF_CREATIVES)
                .where(PERF_CREATIVES.STATUS_MODERATE.notEqual(PerfCreativesStatusmoderate.New))
                .and(PERF_CREATIVES.CREATIVE_TYPE.eq(PerfCreativesCreativeType.performance))
                .and(PERF_CREATIVES.SUM_GEO.isNull())
                .and(PERF_CREATIVES.TEMPLATE_ID.in(740L, 741L, 778L, 779L, 783L, 839L, 910L, 1051L))
                .and(PERF_CREATIVES.CREATIVE_ID.greaterThan(startId))
                .orderBy(PERF_CREATIVES.CREATIVE_ID)
                .limit(batchSize)
                .fetchGroups(PERF_CREATIVES.CLIENT_ID, PERF_CREATIVES.CREATIVE_ID);
    }
}
