package ru.yandex.direct.oneshot.oneshots.updategeotargeting

import ru.yandex.direct.ytwrapper.model.YtField

class AdGroupWithShardTableRow : ConvertibleTableRow<AdGroupWithShard>(listOf(SHARD, PID)) {
    val shard: Int
        get() = valueOf(SHARD)
    val pid: Long
        get() = valueOf(PID)

    companion object {
        private val SHARD = YtField("shard", Int::class.java)
        private val PID = YtField("pid", Long::class.java)
    }

    override fun convert(): AdGroupWithShard {
        return AdGroupWithShard(shard, pid)
    }
}

data class AdGroupWithShard(
    val shard: Int,
    val pid: Long
)
